/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.menu.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Menu {
    private String name;
    private String path;
    private String link;
    private Menu parent = null;
    @JsonIgnore
    private List<Menu> children = new ArrayList<Menu>();

    public Menu() {
        this.name = null;
        this.path = "/";
        this.link = "#";
    }

    public Menu(Menu parentMenu, String name, String link) {
        Validate.notNull((Object)parentMenu, (String)"parent menu may not be null");
        this.name = name;
        this.parent = parentMenu;
        this.parent.addChild(this);
        this.path = parentMenu.getPath() + name + "/";
        this.link = link;
    }

    public List<Menu> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<Menu> getChildren(String path) {
        if (path == null) {
            return Collections.emptyList();
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList<Menu> result = new ArrayList<Menu>();
        String[] pathParts = path.split("/");
        if (pathParts.length == 0) {
            return this.getChildren();
        }
        for (Menu child : this.getChildren()) {
            if (!child.getName().equals(pathParts[1])) continue;
            result.addAll(child.getChildren());
            break;
        }
        return result;
    }

    public void remove(String menuIdentifier) {
    }

    public String getName() {
        return this.name;
    }

    public Menu getParent() {
        return this.parent;
    }

    public String getLink() {
        return this.link;
    }

    public String toString() {
        return this.getPath();
    }

    private void addChild(Menu menu) {
        this.children.add(menu);
    }

    public String getPath() {
        return this.path;
    }
}

