/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.menu;

import de.twenty11.skysail.server.core.MenuService;
import de.twenty11.skysail.server.core.restlet.RouteBuilder;
import de.twenty11.skysail.server.menu.domain.Menu;
import de.twenty11.skysail.server.menu.resources.MenusResource;
import de.twenty11.skysail.server.restlet.SkysailApplication;
import de.twenty11.skysail.server.services.ApplicationProvider;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuApplication
extends SkysailApplication
implements ApplicationProvider,
MenuService {
    private static final Logger logger = LoggerFactory.getLogger(MenuApplication.class);
    public static final String MAIN_MENU_IDENTIFIER = "main";
    public static final String NAV_MENU_IDENTIFIER = "nav";
    private Menu root;
    private Menu mainMenu;
    private Menu navMenu;

    public MenuApplication() {
        this.setName("menu");
        this.setDescription("provides the menus");
        this.setOwner("twenty11");
        this.root = new Menu();
        this.mainMenu = new Menu(this.root, MAIN_MENU_IDENTIFIER, "#");
        this.navMenu = new Menu(this.root, NAV_MENU_IDENTIFIER, "#");
    }

    protected void attach() {
        this.router.setDefaultMatchingMode(1);
        this.router.setRoutingMode(3);
        this.router.attach(new RouteBuilder("", MenusResource.class).setText("menu"));
        this.router.attach(new RouteBuilder("/", MenusResource.class).setText("menu"));
        this.router.attach(new RouteBuilder("/{path}", MenusResource.class).setText("menupath"));
    }

    public void addApplicationToMenu(String appIdentifier, String menuIdentifier, String link) {
        logger.debug("application {} is assigned to menu {}", (Object)appIdentifier, (Object)menuIdentifier);
        new Menu(this.mainMenu, appIdentifier, link);
    }

    public void removeApplicationFromMenu(String appIdentifier, String menuIdentifier) {
        logger.debug("application {} is detached from menu {}", (Object)appIdentifier, (Object)menuIdentifier);
        this.mainMenu.remove(appIdentifier);
    }

    public List<Menu> getMenus(String path) {
        return this.root.getChildren(path);
    }
}

