/*
 * Decompiled with CFR 0.152.
 */
package test.de.twenty11.skysail.server.menu.domain;

import de.twenty11.skysail.server.menu.domain.Menu;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MenuTest {
    private Menu root;
    private Menu mainMenu;

    @Before
    public void setUp() throws Exception {
        this.root = new Menu();
        this.mainMenu = new Menu(this.root, "name", "link");
    }

    @Test
    public void root_has_proper_attributes() {
        Assert.assertThat((Object)this.root.getName(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.root.getParent(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.root.getPath(), (Matcher)Matchers.is((Object)"/"));
    }

    @Test
    public void menu_without_parentMenu_has_proper_attributes() {
        Assert.assertThat((Object)this.mainMenu.getName(), (Matcher)Matchers.is((Object)"name"));
        Assert.assertThat((Object)this.mainMenu.getParent(), (Matcher)Matchers.is((Object)this.root));
        Assert.assertThat((Object)this.mainMenu.getPath(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"/name/")));
    }

    @Test
    public void menu_with_parent_has_proper_path() {
        Menu subMenu = new Menu(this.mainMenu, "sub", "sublink");
        Assert.assertThat((Object)subMenu.getName(), (Matcher)Matchers.is((Object)"sub"));
        Assert.assertThat((Object)subMenu.getParent(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mainMenu)));
        Assert.assertThat((Object)subMenu.getPath(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"/name/sub/")));
    }

    @Test
    public void parent_menu_knows_about_children() {
        Menu subMenu = new Menu(this.mainMenu, "sub", "sublink");
        Assert.assertThat((Object)this.mainMenu.getChildren().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat(this.mainMenu.getChildren().get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)subMenu)));
    }

    @Test
    public void children_are_found_via_path_from_root() {
        new Menu(this.mainMenu, "sub1", "sublink1");
        new Menu(this.mainMenu, "sub2", "sublink2");
        Assert.assertThat((Object)this.root.getChildren("/").size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.root.getChildren("/name/").size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.mainMenu.getChildren("/").size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.mainMenu.getChildren("/sub1").size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    @Ignore
    public void can_remove_child() {
        new Menu(this.mainMenu, "sub1", "sublink1");
        this.mainMenu.remove("sub1");
        Assert.assertThat((Object)this.mainMenu.getChildren("/").size(), (Matcher)Matchers.is((Object)0));
    }
}

