/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.graphs.internal;

import de.twenty11.skysail.common.graphs.Graph;
import de.twenty11.skysail.server.graphs.internal.GraphModelProvider;
import de.twenty11.skysail.server.graphs.internal.GraphsSkysailApplication;
import de.twenty11.skysail.server.graphs.internal.GraphsUrlMapper;
import de.twenty11.skysail.server.services.ApplicationDescriptor;
import de.twenty11.skysail.server.services.UrlMapper;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ContextGraphModelProvider
implements GraphModelProvider {
    private final BundleContext bundleContext;

    public ContextGraphModelProvider(BundleContext context) {
        this.bundleContext = context;
    }

    @Override
    public Map<ApplicationDescriptor, List<String>> getRelevantAppsAndPaths() {
        HashMap<ApplicationDescriptor, List<String>> result = new HashMap<ApplicationDescriptor, List<String>>();
        try {
            ServiceReference[] allSkysailApps = this.bundleContext.getAllServiceReferences(ApplicationDescriptor.class.getName(), null);
            if (allSkysailApps != null) {
                for (ServiceReference serviceReference : allSkysailApps) {
                    ApplicationDescriptor skysailApp = (ApplicationDescriptor)this.bundleContext.getService(serviceReference);
                    String skysailAppName = skysailApp.getApplicationDescription().getName();
                    List<String> paths = this.checkForGraphAnnotations(serviceReference.getBundle());
                    if (paths.size() <= 0) continue;
                    result.put(skysailApp, paths);
                }
            }
            GraphsSkysailApplication.setGraphModelProvider(this);
            return result;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("invalid syntax", e);
        }
    }

    private List<String> checkForGraphAnnotations(Bundle bundleToExamine) {
        ArrayList<String> paths = new ArrayList<String>();
        Enumeration classes = bundleToExamine.findEntries("/", "*.class", true);
        while (classes.hasMoreElements()) {
            try {
                URL nextElement = (URL)classes.nextElement();
                InputStream inputStream = nextElement.openConnection().getInputStream();
                DataInputStream dstream = new DataInputStream(new BufferedInputStream(inputStream));
                ClassFile cf = new ClassFile(dstream);
                Annotation graphAnnotation = this.getAnnotation(cf, Graph.class);
                if (graphAnnotation == null) continue;
                String className = cf.getName();
                List<String> pathsFromMapper = this.getPathsFromUrlMapper(className);
                paths.addAll(pathsFromMapper);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return paths;
    }

    private List<String> getPathsFromUrlMapper(String className) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        ServiceReference[] allUrlMappers = this.bundleContext.getAllServiceReferences(UrlMapper.class.getName(), null);
        if (allUrlMappers != null) {
            for (ServiceReference serviceReference : allUrlMappers) {
                UrlMapper urlMapper = (UrlMapper)this.bundleContext.getService(serviceReference);
                if (urlMapper.getClass().equals(GraphsUrlMapper.class)) continue;
                Map urlMappings = urlMapper.provideUrlMapping();
                for (Map.Entry entry : urlMappings.entrySet()) {
                    if (!((String)entry.getValue()).equals(className)) continue;
                    results.add((String)entry.getKey());
                }
            }
        }
        return results;
    }

    private Annotation getAnnotation(ClassFile cf, Class<?> annotation) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (attribute == null) {
            return null;
        }
        Annotation nodeAnnotation = attribute.getAnnotation(annotation.getName());
        if (nodeAnnotation == null) {
            return null;
        }
        return nodeAnnotation;
    }
}

