/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.graphs.test;

import de.twenty11.skysail.common.app.ApplicationDescription;
import de.twenty11.skysail.common.graphs.GraphDetails;
import de.twenty11.skysail.common.responses.Response;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorComponent;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorUrlMapper;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.graphs.internal.GraphsSkysailApplication;
import de.twenty11.skysail.server.graphs.test.GraphTestClass;
import de.twenty11.skysail.server.services.ApplicationDescriptor;
import de.twenty11.skysail.server.services.UrlMapper;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Restlet;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.security.MapVerifier;
import org.restlet.security.SecretVerifier;

public class BaseTest {
    protected GraphsSkysailApplication graphApplication;
    protected OsgiMonitorViewerApplication osgiMonitorViewerApplication;
    protected Restlet inboundRoot;
    protected ObjectMapper mapper = new ObjectMapper();

    protected BundleContext setupBundleContextMock() throws InvalidSyntaxException {
        BundleContext contextMock = (BundleContext)Mockito.mock(BundleContext.class);
        ServiceReference[] appDescriptorServiceReferencesMock = this.setupAppDescriptorServiceReferencesMock();
        ServiceReference[] appUrlMapperServiceReferencesMock = this.setupUrlMapperServiceReferencesMock();
        Mockito.when((Object)contextMock.getAllServiceReferences(ApplicationDescriptor.class.getName(), null)).thenReturn((Object)appDescriptorServiceReferencesMock);
        Mockito.when((Object)contextMock.getAllServiceReferences(UrlMapper.class.getName(), null)).thenReturn((Object)appUrlMapperServiceReferencesMock);
        Mockito.when((Object)contextMock.getService(appDescriptorServiceReferencesMock[0])).thenReturn((Object)new ApplicationDescriptor(){

            public ApplicationDescription getApplicationDescription() {
                return new ApplicationDescription("appName", "desc", "path");
            }
        });
        Mockito.when((Object)contextMock.getService(appUrlMapperServiceReferencesMock[0])).thenReturn((Object)new UrlMapper(){

            public Map<String, String> provideUrlMapping() {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("/testpath1", GraphTestClass.class.getName());
                result.put("/testpath2/{name}", GraphTestClass.class.getName());
                return result;
            }
        });
        return contextMock;
    }

    private ServiceReference[] setupAppDescriptorServiceReferencesMock() {
        ServiceReference[] serviceReferences = new ServiceReference[1];
        ServiceReference serviceReference = (ServiceReference)Mockito.mock(ServiceReference.class);
        Bundle bundleMock = this.setupBundleMock();
        Mockito.when((Object)serviceReference.getBundle()).thenReturn((Object)bundleMock);
        serviceReferences[0] = serviceReference;
        return serviceReferences;
    }

    private ServiceReference[] setupUrlMapperServiceReferencesMock() {
        ServiceReference[] serviceReferences = new ServiceReference[1];
        ServiceReference serviceReference = (ServiceReference)Mockito.mock(ServiceReference.class);
        Bundle bundleMock = this.setupUrlMapperBundleMock();
        Mockito.when((Object)serviceReference.getBundle()).thenReturn((Object)bundleMock);
        serviceReferences[0] = serviceReference;
        return serviceReferences;
    }

    private Bundle setupBundleMock() {
        Bundle bundleWithGraphAnnotation = (Bundle)Mockito.mock(Bundle.class);
        Enumeration<URL> classes = new Enumeration<URL>(){
            boolean moreElements = true;

            @Override
            public boolean hasMoreElements() {
                return this.moreElements;
            }

            @Override
            public URL nextElement() {
                this.moreElements = false;
                return this.getClass().getResource("GraphTestClass.class");
            }
        };
        Mockito.when((Object)bundleWithGraphAnnotation.findEntries("/", "*.class", true)).thenReturn((Object)classes);
        return bundleWithGraphAnnotation;
    }

    private Bundle setupUrlMapperBundleMock() {
        Bundle bundle = (Bundle)Mockito.mock(Bundle.class);
        return bundle;
    }

    protected OsgiMonitorViewerApplication setUpOsgiMonitorApplication() throws ClassNotFoundException {
        MapVerifier verifier = new MapVerifier();
        verifier.getLocalSecrets().put("admintest", "testpassword".toCharArray());
        ComponentContext contextMock = (ComponentContext)Mockito.mock(ComponentContext.class);
        OsgiMonitorComponent component = new OsgiMonitorComponent(contextMock, (SecretVerifier)verifier);
        this.osgiMonitorViewerApplication = component.getApplication();
        Application.setCurrent((Application)this.osgiMonitorViewerApplication);
        this.inboundRoot = this.osgiMonitorViewerApplication.getInboundRoot();
        this.addMappings((UrlMapper)new OsgiMonitorUrlMapper());
        return this.osgiMonitorViewerApplication;
    }

    protected void addMappings(UrlMapper urlMapper) throws ClassNotFoundException {
        Map urlMapping = urlMapper.provideUrlMapping();
        for (Map.Entry mapping : urlMapping.entrySet()) {
            Class<?> resourceClass = Class.forName((String)mapping.getValue());
            this.osgiMonitorViewerApplication.attachToRouter("" + (String)mapping.getKey(), resourceClass);
        }
    }

    protected List<GraphDetails> getGraphs() throws Exception {
        org.restlet.Response response = this.get("/testapp/graphs");
        this.assertDefaults(response);
        Representation entity = response.getEntity();
        Response skysailResponse = (Response)this.mapper.readValue(entity.getText(), (TypeReference)new TypeReference<Response<List<GraphDetails>>>(){});
        Assert.assertThat((String)skysailResponse.getMessage(), (Object)skysailResponse.getSuccess(), (Matcher)Matchers.is((Object)true));
        return (List)skysailResponse.getData();
    }

    protected org.restlet.Response get(String uri) {
        Request request = new Request(Method.GET, uri);
        return this.handleRequest(request);
    }

    protected org.restlet.Response handleRequest(Request request) {
        ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "admintest", "testpassword");
        request.setChallengeResponse(authentication);
        org.restlet.Response response = new org.restlet.Response(request);
        this.inboundRoot.handle(request, response);
        return response;
    }

    protected void assertDefaults(org.restlet.Response response) {
        Assert.assertEquals((long)200L, (long)response.getStatus().getCode());
        Assert.assertThat((Object)response.isEntityAvailable(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)response.getEntity().getMediaType(), (Matcher)Matchers.is((Object)MediaType.APPLICATION_JSON));
    }
}

