/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.graphs.internal;

import de.twenty11.skysail.server.graphs.internal.Activator;
import de.twenty11.skysail.server.graphs.internal.GraphModelProvider;
import de.twenty11.skysail.server.listener.UrlMappingServiceListener;
import de.twenty11.skysail.server.restlet.RestletOsgiApplication;
import de.twenty11.skysail.server.services.ApplicationDescriptor;
import java.util.List;
import java.util.Map;
import org.osgi.framework.FrameworkUtil;
import org.restlet.Request;
import org.restlet.Response;

public class GraphsSkysailApplication
extends RestletOsgiApplication {
    private static GraphsSkysailApplication self;
    private static GraphModelProvider graphModelProvider;

    public GraphsSkysailApplication(String staticPathTemplate) {
        super("graphs", staticPathTemplate);
        this.setDescription("RESTful DbViewer Graph bundle");
        this.setOwner("twentyeleven");
        self = this;
    }

    public static synchronized GraphsSkysailApplication get() {
        if (self == null) {
            self = new GraphsSkysailApplication("/static");
            GraphsSkysailApplication.setGraphModelProvider(Activator.getGraphModelProvider());
        }
        return self;
    }

    public void handle(Request request, Response response) {
        super.handle(request, response);
    }

    protected void attach() {
        if (FrameworkUtil.getBundle(RestletOsgiApplication.class) != null) {
            new UrlMappingServiceListener((RestletOsgiApplication)this);
        }
    }

    public static void setGraphModelProvider(GraphModelProvider gmp) {
        graphModelProvider = gmp;
    }

    public Map<ApplicationDescriptor, List<String>> getRelevantAppsAndPaths() {
        return graphModelProvider.getRelevantAppsAndPaths();
    }
}

