/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.graphs;

import de.twenty11.skysail.common.graphs.EdgeDetails;
import de.twenty11.skysail.common.graphs.EdgeProvider;
import de.twenty11.skysail.common.graphs.GraphDetails;
import de.twenty11.skysail.common.graphs.NodeDetails;
import de.twenty11.skysail.common.graphs.NodeProvider;
import de.twenty11.skysail.common.graphs.OutgoingEdgesProvider;
import de.twenty11.skysail.common.graphs.RestfulGraph;
import de.twenty11.skysail.common.responses.Response;
import de.twenty11.skysail.server.restlet.GenericServerResource;
import de.twenty11.skysail.server.restlet.RestletOsgiApplication;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphsResource
extends GenericServerResource<GraphDetails>
implements RestfulGraph {
    private static Logger logger = LoggerFactory.getLogger(GraphsResource.class);
    private String resourceRef;
    private final ObjectMapper mapper = new ObjectMapper();

    public GraphsResource() {
        this.setName("generic graph representation resource");
        this.setDescription("The graph representation for the referenced resource");
    }

    protected void doInit() throws ResourceException {
        this.resourceRef = this.getRequest().getResourceRef().getParentRef().toString();
        this.resourceRef = this.resourceRef.substring(0, this.resourceRef.length() - 1);
    }

    @Get
    public Response<GraphDetails> getGraph() {
        return this.getEntity(this.graphRepresentation());
    }

    private GraphDetails graphRepresentation() {
        RestletOsgiApplication application = (RestletOsgiApplication)this.getApplication();
        String applicationName = application.getApplicationName();
        GraphDetails graphDetails = new GraphDetails("graph");
        this.resourceRef = "riap://host/osgimonitor/bundles";
        ClientResource columns = new ClientResource(this.resourceRef);
        this.getContext().getDefaultVerifier();
        this.getClientInfo().getPrincipals();
        this.getClientInfo().getUser();
        this.getChallengeRequests();
        columns.setChallengeResponse(this.getChallengeResponse());
        this.getConditions();
        this.getProxyChallengeRequests();
        this.getRequestAttributes();
        Representation representation = columns.get();
        try {
            String representationAsText = representation.getText();
            this.createNodes(graphDetails, representationAsText);
            this.createEdges(graphDetails, representationAsText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graphDetails;
    }

    private void createNodes(GraphDetails graphDetails, String representationAsText) throws IOException, JsonParseException, JsonMappingException {
        Response response = (Response)this.mapper.readValue(representationAsText, (TypeReference)new TypeReference<Response<List<? extends NodeProvider>>>(){});
        List payload = (List)response.getData();
        for (NodeProvider nodeProvider : payload) {
            NodeDetails node = new NodeDetails(nodeProvider.getNodeId(), nodeProvider.getNodeLabel());
            graphDetails.addNode(node);
        }
    }

    private void createEdges(GraphDetails graphDetails, String representationAsText) throws IOException, JsonParseException, JsonMappingException {
        Response response = (Response)this.mapper.readValue(representationAsText, (TypeReference)new TypeReference<Response<List<? extends OutgoingEdgesProvider>>>(){});
        List payload = (List)response.getData();
        for (OutgoingEdgesProvider edgesProvider : payload) {
            for (EdgeProvider edgeProvider : edgesProvider.getEdges()) {
                EdgeDetails edge = new EdgeDetails(edgeProvider.getEdgeLabel(), edgeProvider.getSource(), edgeProvider.getTarget());
                graphDetails.addEdge(edge);
            }
        }
    }
}

