/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor;

import de.twenty11.skysail.common.ext.osgimonitor.BundleDescriptor;
import de.twenty11.skysail.common.ext.osgimonitor.BundleDetails;
import de.twenty11.skysail.common.ext.osgimonitor.RestfulBundles;
import de.twenty11.skysail.common.ext.osgimonitor.ServiceReferenceDetails;
import de.twenty11.skysail.common.responses.Response;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.restlet.ListServerResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class BundlesResource
extends ListServerResource<BundleDescriptor>
implements RestfulBundles {
    private List<Bundle> bundles;

    public BundlesResource() {
        this.setName("osgimonitor bundles resource");
        this.setDescription("The resource containing the list of bundles");
    }

    protected void doInit() throws ResourceException {
        OsgiMonitorViewerApplication app = (OsgiMonitorViewerApplication)this.getApplication();
        BundleContext bundleContext = app.getBundleContext();
        this.bundles = bundleContext == null ? Collections.emptyList() : Arrays.asList(bundleContext.getBundles());
    }

    @Get(value="html|json")
    public Response<List<BundleDescriptor>> getBundles() {
        return this.getEntities(this.allBundles(), "all Bundles");
    }

    @Post
    public Representation install(String location) {
        String prefix = "prefix";
        if (!location.startsWith(prefix)) {
            return new StringRepresentation((CharSequence)("location didn't start with '" + prefix + "'"));
        }
        return new StringRepresentation((CharSequence)"success");
    }

    private List<BundleDescriptor> allBundles() {
        ArrayList<BundleDescriptor> result = new ArrayList<BundleDescriptor>();
        for (Bundle bundle : this.bundles) {
            BundleDescriptor bundleDetail = new BundleDescriptor(bundle);
            result.add(bundleDetail);
        }
        return result;
    }

    private List<ServiceReferenceDetails> getDetails(ServiceReference[] registeredServices) {
        ArrayList<ServiceReferenceDetails> details = new ArrayList<ServiceReferenceDetails>();
        if (registeredServices == null) {
            return details;
        }
        for (ServiceReference serviceReference : registeredServices) {
            ServiceReferenceDetails srd = new ServiceReferenceDetails();
            srd.setBundleId(serviceReference.getBundle().getBundleId());
            srd.setName(serviceReference.toString());
            srd.setUsingBundles(this.getDetails(serviceReference.getUsingBundles()));
            details.add(srd);
        }
        return details;
    }

    private List<BundleDetails> getDetails(Bundle[] usingBundles) {
        ArrayList<BundleDetails> details = new ArrayList<BundleDetails>();
        if (usingBundles == null) {
            return details;
        }
        for (Bundle bundle : usingBundles) {
            BundleDetails bundleDetails = new BundleDetails();
            bundleDetails.setBundleId(bundle.getBundleId());
            bundleDetails.setSymbolicName(bundle.getSymbolicName());
            bundleDetails.setVersion(bundle.getVersion());
            details.add(bundleDetails);
        }
        return details;
    }
}

