/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor;

import de.twenty11.skysail.common.ext.osgimonitor.BundleDetails;
import de.twenty11.skysail.common.ext.osgimonitor.ServiceReferenceDetails;
import de.twenty11.skysail.common.graphs.Graph;
import de.twenty11.skysail.common.graphs.NodeProvider;
import de.twenty11.skysail.common.responses.Response;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.restlet.ListServerResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;

@Graph(nodesPath="/osgimonitor/bundles", edgesPath="/osgimonitor/services")
public class BundlesAsGraphResource
extends ListServerResource<NodeProvider> {
    private List<Bundle> bundles;

    public BundlesAsGraphResource() {
        this.setName("osgimonitor bundles resource");
        this.setDescription("The resource containing the list of bundles");
    }

    protected void doInit() throws ResourceException {
        OsgiMonitorViewerApplication app = (OsgiMonitorViewerApplication)this.getApplication();
        BundleContext bundleContext = app.getBundleContext();
        this.bundles = bundleContext == null ? Collections.emptyList() : Arrays.asList(bundleContext.getBundles());
    }

    @Get(value="html|json")
    public Response<List<NodeProvider>> getBundles() {
        ArrayList<NodeProvider> allBundlesAsNodes = new ArrayList<NodeProvider>();
        List<BundleDetails> allBundles = this.allBundles();
        for (BundleDetails bundleDetails : allBundles) {
            allBundlesAsNodes.add(bundleDetails.asNode());
        }
        return this.getEntities(allBundlesAsNodes, "all Bundles as Graph");
    }

    private List<BundleDetails> allBundles() {
        ArrayList<BundleDetails> result = new ArrayList<BundleDetails>();
        for (Bundle bundle : this.bundles) {
            BundleDetails bundleDetail = new BundleDetails();
            bundleDetail.setSymbolicName(bundle.getLocation());
            bundleDetail.setBundleId(bundle.getBundleId());
            bundleDetail.setLastModified(bundle.getLastModified());
            bundleDetail.setRegisteredServices(this.getDetails(bundle.getRegisteredServices()));
            bundleDetail.setServicesInUse(this.getDetails(bundle.getServicesInUse()));
            bundleDetail.setState(Integer.valueOf(bundle.getState()));
            bundleDetail.setVersion(bundle.getVersion());
            bundleDetail.setSymbolicName(bundle.getSymbolicName());
            result.add(bundleDetail);
        }
        return result;
    }

    private Map<String, String> getDetails(Dictionary headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            Object nextElement = keys.nextElement();
            result.put(nextElement.toString(), headers.get(nextElement).toString());
        }
        return result;
    }

    private List<ServiceReferenceDetails> getDetails(ServiceReference[] registeredServices) {
        ArrayList<ServiceReferenceDetails> details = new ArrayList<ServiceReferenceDetails>();
        if (registeredServices == null) {
            return details;
        }
        for (ServiceReference serviceReference : registeredServices) {
            ServiceReferenceDetails srd = new ServiceReferenceDetails();
            srd.setBundleId(serviceReference.getBundle().getBundleId());
            srd.setName(serviceReference.toString());
            srd.setUsingBundles(this.getDetails(serviceReference.getUsingBundles()));
            details.add(srd);
        }
        return details;
    }

    private List<BundleDetails> getDetails(Bundle[] usingBundles) {
        ArrayList<BundleDetails> details = new ArrayList<BundleDetails>();
        if (usingBundles == null) {
            return details;
        }
        for (Bundle bundle : usingBundles) {
            BundleDetails bundleDetails = new BundleDetails();
            bundleDetails.setBundleId(bundle.getBundleId());
            bundleDetails.setSymbolicName(bundle.getSymbolicName());
            bundleDetails.setVersion(bundle.getVersion());
            details.add(bundleDetails);
        }
        return details;
    }
}

