/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor;

import de.twenty11.skysail.common.ext.osgimonitor.BundleDetails;
import de.twenty11.skysail.common.ext.osgimonitor.RestfulBundle;
import de.twenty11.skysail.common.responses.Response;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.restlet.UniqueResultServerResource;
import java.util.Arrays;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class BundleResource
extends UniqueResultServerResource<BundleDetails>
implements RestfulBundle {
    private String bundleId;
    private String action;

    public BundleResource() {
        this.setName("osgimonitor bundle resource");
        this.setDescription("The resource containing bundle detail information");
    }

    protected void doInit() throws ResourceException {
        this.bundleId = (String)this.getRequest().getAttributes().get("bundleId");
        this.action = (String)this.getRequest().getAttributes().get("action");
    }

    @Get(value="html|json")
    public Response<BundleDetails> getBundle() {
        OsgiMonitorViewerApplication app = (OsgiMonitorViewerApplication)this.getApplication();
        BundleContext bundleContext = app.getBundleContext();
        Bundle bundle = bundleContext.getBundle(Long.parseLong(this.bundleId));
        BundleDetails details = new BundleDetails(bundle);
        return this.getEntity(details);
    }

    @Get(value="putform")
    public Representation formWithPut() {
        if (Arrays.asList("start", "stop", "update").contains(this.action)) {
            String start = "<html><head><title>form to issue PUT request</title></head>\n<body>\n";
            String stop = "</body></html>";
            StringRepresentation stringRepresentation = new StringRepresentation((CharSequence)(start + "<form action='?method=PUT' method='POST'><input type='submit'></form>" + stop));
            stringRepresentation.setMediaType(MediaType.TEXT_HTML);
            return stringRepresentation;
        }
        return new StringRepresentation((CharSequence)"only 'start','stop' and 'update' are allowed as action");
    }

    @Put
    public Representation startOrStopBundle() {
        OsgiMonitorViewerApplication app = (OsgiMonitorViewerApplication)this.getApplication();
        BundleContext bundleContext = app.getBundleContext();
        Bundle bundle = bundleContext.getBundle(Long.parseLong(this.bundleId));
        Reference resourceRef = this.getRequest().getResourceRef();
        try {
            if (resourceRef.toString().endsWith("/start")) {
                bundle.start();
            } else if (resourceRef.toString().endsWith("/stop")) {
                bundle.stop();
            } else if (resourceRef.toString().endsWith("/update")) {
                bundle.update();
            }
            return new StringRepresentation((CharSequence)"Success!");
        }
        catch (BundleException e) {
            e.printStackTrace();
            return new StringRepresentation((CharSequence)("Failure: " + e.getMessage()));
        }
    }
}

