/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor.test;

import de.twenty11.skysail.common.ext.osgimonitor.HeaderDescriptor;
import de.twenty11.skysail.common.responses.SkysailResponse;
import de.twenty11.skysail.server.ext.osgimonitor.HeaderResource;
import de.twenty11.skysail.server.ext.osgimonitor.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.ext.osgimonitor.test.BaseTests;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.restlet.Context;
import org.restlet.Request;

public class HeaderResourceTest
extends BaseTests {
    private HeaderResource headerResource;
    private Bundle bundle;

    @Before
    public void setUp() throws Exception {
        OsgiMonitorViewerApplication spy = this.setUpRestletApplication();
        BundleContext bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        this.bundle = (Bundle)Mockito.mock(Bundle.class);
        Mockito.when((Object)this.bundle.getBundleId()).thenReturn((Object)99L);
        Mockito.when((Object)this.bundle.getSymbolicName()).thenReturn((Object)"symbolic");
        Mockito.when((Object)this.bundle.getLastModified()).thenReturn((Object)111L);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("key1", "value1");
        ((Dictionary)dictionary).put("key2", "value2");
        Mockito.when((Object)this.bundle.getHeaders()).thenReturn(dictionary);
        Mockito.when((Object)bundleContext.getBundle(99L)).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.bundle.getVersion()).thenReturn((Object)new Version("1.0.0"));
        Mockito.when((Object)spy.getBundleContext()).thenReturn((Object)bundleContext);
        Context context = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)context.getAttributes()).thenReturn(new ConcurrentHashMap());
        this.headerResource = new HeaderResource();
        Request request = (Request)Mockito.mock(Request.class);
        ConcurrentHashMap<String, String> attributes = new ConcurrentHashMap<String, String>();
        attributes.putIfAbsent("bundleId", "99");
        Mockito.when((Object)request.getAttributes()).thenReturn(attributes);
        this.headerResource.init(context, request, null);
    }

    @Test
    public void getHeader_returns_headerDetails_for_bundleId_from_request() throws Exception {
        SkysailResponse headers = this.headerResource.getHeader();
        HeaderDescriptor details = (HeaderDescriptor)headers.getData();
        Assert.assertThat((Object)details.getContent().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
    }
}

