/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor.test;

import de.twenty11.skysail.common.ext.osgimonitor.BundleDescriptor;
import de.twenty11.skysail.server.ext.osgimonitor.BundlesResource;
import de.twenty11.skysail.server.ext.osgimonitor.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.ext.osgimonitor.test.BaseTests;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.restlet.Request;
import org.restlet.representation.Representation;

public class BundlesResourceTest
extends BaseTests {
    private BundlesResource resource;

    @Before
    public void setUp() throws Exception {
        OsgiMonitorViewerApplication spy = this.setUpRestletApplication();
        BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
        Bundle bundle = (Bundle)Mockito.mock(Bundle.class);
        Mockito.when((Object)bundle.getBundleId()).thenReturn((Object)99L);
        Mockito.when((Object)bundle.getSymbolicName()).thenReturn((Object)"symbolic");
        Mockito.when((Object)bundle.getLastModified()).thenReturn((Object)111L);
        Mockito.when((Object)bundle.getVersion()).thenReturn((Object)new Version("1.2.3.qualifier"));
        Mockito.when((Object)bundle.getState()).thenReturn((Object)32);
        Bundle[] bundles = new Bundle[]{bundle};
        Mockito.when((Object)context.getBundles()).thenReturn((Object)bundles);
        Mockito.when((Object)spy.getBundleContext()).thenReturn((Object)context);
        this.resource = new BundlesResource();
        Request request = (Request)Mockito.mock(Request.class);
        ConcurrentHashMap<String, String> attributes = new ConcurrentHashMap<String, String>();
        attributes.putIfAbsent("bundleId", "99");
        Mockito.when((Object)request.getAttributes()).thenReturn(attributes);
        this.resource.init(spy.getContext(), request, null);
    }

    @Test
    public void returns_bundles_with_proper_values() throws Exception {
        List<BundleDescriptor> bundles = this.getBundles();
        Assert.assertThat((Object)bundles.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Assert.assertThat((Object)bundles.get(0).getVersion(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"1.2.3.qualifier")));
        Assert.assertThat((Object)bundles.get(0).getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Active")));
    }

    @Test
    @Ignore
    public void gives_error_message_for_post_when_location_doesnt_start_with_prefix() throws Exception {
        Representation answer = this.resource.install("wrongLocation");
        Assert.assertThat((Object)answer.getText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"location didn't start with 'prefix'")));
    }
}

