/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor.test;

import de.twenty11.skysail.common.ext.osgimonitor.BundleDescriptor;
import de.twenty11.skysail.common.ext.osgimonitor.BundleDetails;
import de.twenty11.skysail.common.responses.SkysailResponse;
import de.twenty11.skysail.server.ext.osgimonitor.BundleResource;
import de.twenty11.skysail.server.ext.osgimonitor.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.ext.osgimonitor.test.BaseTests;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.type.TypeReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.representation.Representation;

public class BundleResourceTest
extends BaseTests {
    private BundleResource bundleResource;
    private Bundle bundle;

    @Before
    public void setUp() throws Exception {
        OsgiMonitorViewerApplication spy = this.setUpRestletApplication();
        BundleContext bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        this.bundle = (Bundle)Mockito.mock(Bundle.class);
        Mockito.when((Object)this.bundle.getBundleId()).thenReturn((Object)99L);
        Mockito.when((Object)this.bundle.getSymbolicName()).thenReturn((Object)"symbolic");
        Mockito.when((Object)this.bundle.getLastModified()).thenReturn((Object)111L);
        Mockito.when((Object)bundleContext.getBundle(99L)).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.bundle.getVersion()).thenReturn((Object)new Version("1.0.0"));
        Mockito.when((Object)spy.getBundleContext()).thenReturn((Object)bundleContext);
        Context context = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)context.getAttributes()).thenReturn(new ConcurrentHashMap());
        this.bundleResource = new BundleResource();
        Request request = (Request)Mockito.mock(Request.class);
        ConcurrentHashMap<String, String> attributes = new ConcurrentHashMap<String, String>();
        attributes.putIfAbsent("bundleId", "99");
        Mockito.when((Object)request.getAttributes()).thenReturn(attributes);
        this.bundleResource.init(context, request, null);
    }

    @Test
    public void getBundle_returns_bundleDetails_for_bundleId_from_request() throws Exception {
        SkysailResponse bundle = this.bundleResource.getBundle();
        BundleDescriptor details = (BundleDescriptor)bundle.getData();
        Assert.assertThat((Object)details.getBundleId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)99L)));
    }

    @Test
    @Ignore
    public void canIssue_GET_request() throws Exception {
        Response response = this.get("bundles/details/99");
        this.assertDefaults(response);
        Representation entity = response.getEntity();
        System.out.println(entity.getText());
        SkysailResponse skysailResponse = (SkysailResponse)this.mapper.readValue(entity.getText(), (TypeReference)new TypeReference<SkysailResponse<BundleDetails>>(){});
    }

    @Test
    @Ignore
    public void canIssue_PUT_request_to_start_bundle() throws Exception {
        Response response = this.put("bundles/details/99/start");
        this.assertDefaults(response);
        Representation entity = response.getEntity();
        Assert.assertThat((Object)entity.getText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Success!")));
        ((Bundle)Mockito.verify((Object)this.bundle)).start();
    }

    @Test
    @Ignore
    public void canIssue_PUT_request_to_stop_bundle() throws Exception {
        Response response = this.put("bundles/details/99/stop");
        this.assertDefaults(response);
        Representation entity = response.getEntity();
        Assert.assertThat((Object)entity.getText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Success!")));
        ((Bundle)Mockito.verify((Object)this.bundle)).stop();
    }

    @Test
    @Ignore
    public void canIssue_PUT_request_to_update_bundle() throws Exception {
        Response response = this.put("bundles/details/99/update");
        this.assertDefaults(response);
        Representation entity = response.getEntity();
        Assert.assertThat((Object)entity.getText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Success!")));
        ((Bundle)Mockito.verify((Object)this.bundle)).update();
    }
}

