/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor.test;

import de.twenty11.skysail.common.ext.osgimonitor.BundleDescriptor;
import de.twenty11.skysail.common.ext.osgimonitor.ServiceDescriptor;
import de.twenty11.skysail.common.responses.SkysailResponse;
import de.twenty11.skysail.server.ext.osgimonitor.OsgiMonitorViewerApplication;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;
import org.osgi.service.component.ComponentContext;
import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.security.MapVerifier;
import org.restlet.security.Verifier;

public class BaseTests {
    protected OsgiMonitorViewerApplication osgiMonitorViewerApplication;
    protected Restlet inboundRoot;
    protected ObjectMapper mapper = new ObjectMapper();
    private ComponentContext componentContextMock = (ComponentContext)Mockito.mock(ComponentContext.class);

    protected OsgiMonitorViewerApplication setUpRestletApplication() throws ClassNotFoundException {
        MapVerifier secretVerifier = new MapVerifier();
        secretVerifier.getLocalSecrets().put("testadmin", "testpassword".toCharArray());
        this.osgiMonitorViewerApplication = new OsgiMonitorViewerApplication(null);
        this.osgiMonitorViewerApplication.setVerifier((Verifier)secretVerifier);
        OsgiMonitorViewerApplication spy = (OsgiMonitorViewerApplication)Mockito.spy((Object)this.osgiMonitorViewerApplication);
        Application.setCurrent((Application)spy);
        this.inboundRoot = this.osgiMonitorViewerApplication.getInboundRoot();
        return spy;
    }

    protected List<BundleDescriptor> getBundles() throws Exception {
        Response response = this.get("bundles");
        this.assertDefaults(response);
        Representation entity = response.getEntity();
        SkysailResponse skysailResponse = (SkysailResponse)this.mapper.readValue(entity.getText(), (TypeReference)new TypeReference<SkysailResponse<List<BundleDescriptor>>>(){});
        MatcherAssert.assertThat((String)skysailResponse.getMessage(), (Object)skysailResponse.getSuccess(), (Matcher)Matchers.is((Object)true));
        return (List)skysailResponse.getData();
    }

    protected List<ServiceDescriptor> getServices() throws Exception {
        Response response = this.get("services");
        this.assertDefaults(response);
        Representation entity = response.getEntity();
        SkysailResponse skysailResponse = (SkysailResponse)this.mapper.readValue(entity.getText(), (TypeReference)new TypeReference<SkysailResponse<List<ServiceDescriptor>>>(){});
        MatcherAssert.assertThat((String)skysailResponse.getMessage(), (Object)skysailResponse.getSuccess(), (Matcher)Matchers.is((Object)true));
        return (List)skysailResponse.getData();
    }

    private Response delete(String uri) {
        Request request = new Request(Method.DELETE, "/" + uri);
        return this.handleRequest(request);
    }

    protected Response get(String uri) {
        Request request = new Request(Method.GET, "/" + uri);
        return this.handleRequest(request);
    }

    protected Response put(String uri) {
        Request request = new Request(Method.PUT, "/" + uri);
        return this.handleRequest(request);
    }

    protected Response post(String uri, Object connection) throws JsonGenerationException, JsonMappingException, IOException {
        Request request = new Request(Method.POST, "/" + uri);
        String writeValueAsString = this.mapper.writeValueAsString(connection);
        request.setEntity(writeValueAsString, MediaType.APPLICATION_JSON);
        return this.handleRequest(request);
    }

    protected Response handleRequest(Request request) {
        ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "testadmin", "testpassword");
        request.setChallengeResponse(authentication);
        Response response = new Response(request);
        this.inboundRoot.handle(request, response);
        return response;
    }

    protected void assertDefaults(Response response) {
        Assert.assertEquals((long)200L, (long)response.getStatus().getCode());
        MatcherAssert.assertThat((Object)response.isEntityAvailable(), (Matcher)Matchers.is((Object)true));
    }
}

