/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor;

import de.twenty11.skysail.server.ext.osgimonitor.Configuration;
import de.twenty11.skysail.server.ext.osgimonitor.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.services.ApplicationProvider;
import de.twenty11.skysail.server.services.ComponentProvider;
import java.util.Dictionary;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.restlet.Component;
import org.restlet.Context;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationTest {
    @Mock
    private ApplicationProvider applicationProvider;
    @Mock
    private ComponentProvider componentProvider;
    @Mock
    private ComponentContext componentContext;
    @Mock
    private BundleContext bundleContext;
    @Mock
    private ServiceRegistration serviceRegistration;
    @Mock
    private Context context;
    private TestConfiguration testConfiguration = new TestConfiguration();
    private Component component = new Component();

    @Before
    public void createConfiguration() throws Exception {
        OsgiMonitorViewerApplication application = new OsgiMonitorViewerApplication(this.bundleContext, this.context);
        Mockito.when((Object)this.bundleContext.registerService(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyObject(), (Dictionary)org.mockito.Matchers.isNull())).thenReturn((Object)this.serviceRegistration);
        Mockito.when((Object)this.componentContext.getBundleContext()).thenReturn((Object)this.bundleContext);
        Mockito.when((Object)this.componentProvider.getComponent()).thenReturn((Object)this.component);
        Mockito.when((Object)this.applicationProvider.getApplication()).thenReturn((Object)application);
    }

    @Test
    public void can_activate_component() throws Exception {
        this.testConfiguration.setComponentProvider(this.componentProvider);
        this.testConfiguration.activate(this.componentContext);
    }

    @Test
    @Ignore
    public void can_deactivate_component() throws Exception {
        this.testConfiguration.setComponentProvider(this.componentProvider);
        this.testConfiguration.activate(this.componentContext);
        this.testConfiguration.deactivate(this.componentContext);
    }

    @Test
    @Ignore
    public void can_deal_with_new_application() throws Exception {
        this.testConfiguration.setComponentProvider(this.componentProvider);
        this.testConfiguration.activate(this.componentContext);
        Assert.assertThat((Object)this.component.getDefaultHost().getRoutes().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    @Ignore
    public void can_remove_added_application() throws Exception {
        this.testConfiguration.setComponentProvider(this.componentProvider);
        this.testConfiguration.activate(this.componentContext);
        Assert.assertThat((Object)this.component.getDefaultHost().getRoutes().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    private class TestConfiguration
    extends Configuration {
        private TestConfiguration() {
        }

        protected void activate(ComponentContext componentContext) throws ConfigurationException {
            super.activate(componentContext);
        }

        protected void deactivate(ComponentContext componentContext) {
            super.deactivate(componentContext);
        }
    }
}

