/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor.internal;

import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorViewerApplication;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.routing.VirtualHost;
import org.restlet.security.SecretVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiMonitorComponent
extends Component {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private OsgiMonitorViewerApplication application;
    private ServiceRegistration registration;

    public OsgiMonitorComponent(ComponentContext componentContext, SecretVerifier verifier) {
        this.getClients().add(Protocol.CLAP);
        this.getClients().add(Protocol.HTTP);
        this.logger.info("new restlet application: {}", (Object)OsgiMonitorViewerApplication.class.getName());
        this.application = new OsgiMonitorViewerApplication("/static", componentContext.getBundleContext());
        this.application.setVerifier(verifier);
        this.logger.info("attaching application and starting {}", (Object)((Object)((Object)this)).toString());
        this.getDefaultHost().attachDefault((Restlet)this.application);
        VirtualHost virtualHost = this.createVirtualHost();
        if (componentContext.getBundleContext() != null) {
            this.registration = componentContext.getBundleContext().registerService("org.restlet.routing.VirtualHost", (Object)virtualHost, null);
        }
    }

    private VirtualHost createVirtualHost() {
        VirtualHost vh = new VirtualHost();
        vh.setHostDomain("127.0.0.1");
        vh.setHostPort("2013");
        vh.attach((Restlet)this);
        return vh;
    }

    public ServiceRegistration getRegistration() {
        return this.registration;
    }

    public OsgiMonitorViewerApplication getApplication() {
        return this.application;
    }
}

