/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor.internal;

import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorComponent;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.security.MapVerifier;
import org.restlet.security.SecretVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements ManagedService {
    private static Logger logger = LoggerFactory.getLogger(Configuration.class);
    private OsgiMonitorComponent restletComponent;
    private Server server;
    private ComponentContext context;
    private ConfigurationAdmin configadmin;

    protected void activate(ComponentContext ctxt) {
        logger.info("Activating Skysail Ext Osgimonitor Configuration Component");
        this.context = ctxt;
    }

    protected void deactivate(ComponentContext ctxt) {
        logger.info("Deactivating Skysail Ext Osgimonitor Configuration Component");
        this.context = null;
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            logger.error("Exception when trying to stop standalone server", (Throwable)e);
        }
        if (this.restletComponent != null && this.restletComponent.getRegistration() != null) {
            this.restletComponent.getRegistration().unregister();
        }
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        Dictionary config;
        logger.info("Configuring Skysail Ext Osgimonitor...");
        Dictionary dictionary = config = properties == null ? this.getDefaultConfig() : properties;
        if (this.startStandaloneServer()) {
            String port = (String)config.get("port");
            logger.info("port was configured on {}", (Object)port);
            MapVerifier verifier = new MapVerifier();
            try {
                if (!this.setSecretVerifier(verifier)) {
                    logger.warn("not starting up the application due to encountered configuration problems.");
                    return;
                }
            }
            catch (Exception e) {
                logger.error("Configuring secretVerifier encountered a problem: {}", (Object)e.getMessage());
                e.printStackTrace();
                throw new ConfigurationException("secrets", "file not found", (Throwable)e);
            }
            logger.info("Starting standalone osgimonitor server on port {}", (Object)port);
            this.restletComponent = new OsgiMonitorComponent(this.context, (SecretVerifier)verifier);
            this.startStandaloneServer(port);
        }
    }

    public synchronized void setConfigAdmin(ConfigurationAdmin configadmin) {
        logger.info("setting configadmin in OsgiMonitor Configuration");
        this.configadmin = configadmin;
    }

    private boolean setSecretVerifier(MapVerifier verifier) throws IOException {
        logger.info("gettings 'secrets' configuration...");
        if (this.configadmin == null) {
            logger.error("configadmin is not set, cannot proceed with configuration; no one will be able to log in!");
            return false;
        }
        org.osgi.service.cm.Configuration secrets = this.configadmin.getConfiguration("secrets");
        if (secrets == null) {
            logger.error("could not find 'secrets' configuration; no one will be able to log in!");
            return false;
        }
        Dictionary secretsProperties = secrets.getProperties();
        if (secretsProperties == null || secretsProperties.keys() == null) {
            logger.error("secretProperties is null or empty; no one will be able to log in!");
            return false;
        }
        Enumeration keys = secretsProperties.keys();
        while (keys.hasMoreElements()) {
            String passCandidate;
            String key = (String)keys.nextElement();
            if (!key.startsWith("user.") || !(passCandidate = (String)secretsProperties.get(key)).startsWith("password.")) continue;
            logger.info("setting password for user {}", (Object)key.substring("user.".length()));
            verifier.getLocalSecrets().put(key.substring("user.".length()), passCandidate.substring("password.".length()).toCharArray());
        }
        return true;
    }

    private Dictionary getDefaultConfig() {
        logger.info("Configuring Skysail Ext Osgimonitor with defaults");
        Properties properties = new Properties();
        properties.put("port", "8554");
        return properties;
    }

    private boolean startStandaloneServer() {
        return true;
    }

    private void startStandaloneServer(String portAsString) {
        try {
            this.server = new Server(Protocol.HTTP, Integer.valueOf(portAsString).intValue(), (Restlet)this.restletComponent);
            this.server.start();
        }
        catch (Exception e) {
            logger.error("Exception when starting standalone server", (Throwable)e);
        }
    }
}

