/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor;

import de.twenty11.skysail.common.responses.Response;
import de.twenty11.skysail.common.selfdescription.ResourceDetails;
import de.twenty11.skysail.common.selfdescription.RestfulRoot;
import de.twenty11.skysail.server.restlet.ListServerResource;
import de.twenty11.skysail.server.restlet.RestletOsgiApplication;
import de.twenty11.skysail.server.restlet.SkysailServerResource2;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Restlet;
import org.restlet.resource.Finder;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Route;
import org.restlet.routing.TemplateRoute;
import org.restlet.util.RouteList;

public class OsgiMonitorRootResource
extends ListServerResource<ResourceDetails>
implements RestfulRoot {
    public OsgiMonitorRootResource() {
        this.setAutoDescribing(false);
        this.setName("osgimonitor root resource");
        this.setDescription("The root resource of the osgimonitor application");
    }

    @Get
    public Response<List<ResourceDetails>> getMethods() {
        return this.getEntities(this.allMethods(), "skysail osgimonitor application (x.y.z-SNAPSHOT): listing all entry points");
    }

    private List<ResourceDetails> allMethods() {
        ArrayList<ResourceDetails> result = new ArrayList<ResourceDetails>();
        RestletOsgiApplication restletOsgiApp = (RestletOsgiApplication)this.getApplication();
        RouteList routes = restletOsgiApp.getRoutes();
        for (Route route : routes) {
            if (!(route instanceof TemplateRoute)) continue;
            this.handleTemplateRoutes(result, route);
        }
        return result;
    }

    private void handleTemplateRoutes(List<ResourceDetails> result, Route route) {
        String from;
        TemplateRoute tr = (TemplateRoute)route;
        String string = from = tr.getTemplate() == null ? super.toString() : tr.getTemplate().getPattern();
        if (!from.contains("{")) {
            Restlet next;
            from = this.getHostRef() + from + "?media=json";
            String to = tr.getNext() == null ? "null" : tr.getNext().toString();
            String desc = "no description available";
            if (tr.getNext() != null && (next = tr.getNext()) instanceof Finder) {
                Finder finder = (Finder)next;
                Class targetClass = finder.getTargetClass();
                try {
                    ServerResource serverResource = (ServerResource)targetClass.newInstance();
                    if (serverResource instanceof SkysailServerResource2) {
                        SkysailServerResource2 ssr = (SkysailServerResource2)serverResource;
                        desc = ssr.getDescription();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                next.getFinderClass();
            }
            ResourceDetails resourceDetails = new ResourceDetails(from, to, desc);
            result.add(resourceDetails);
        }
    }
}

