/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor;

import de.twenty11.skysail.common.ext.osgimonitor.BundleDetails;
import de.twenty11.skysail.common.ext.osgimonitor.RestfulBundles;
import de.twenty11.skysail.common.ext.osgimonitor.ServiceReferenceDetails;
import de.twenty11.skysail.common.graphs.Graph;
import de.twenty11.skysail.common.responses.Response;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorViewerApplication;
import de.twenty11.skysail.server.restlet.ListServerResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

@Graph(nodesPath="/osgimonitor/bundles", edgesPath="/osgimonitor/services")
public class BundlesResource
extends ListServerResource<BundleDetails>
implements RestfulBundles {
    private List<Bundle> bundles;

    public BundlesResource() {
        this.setName("osgimonitor bundles resource");
        this.setDescription("The resource containing the list of bundles");
    }

    @Get(value="html")
    public Response<List<BundleDetails>> getBundles() {
        this.getVariants(Method.GET);
        return this.getEntities(this.allBundles(), "all Bundles");
    }

    protected void doInit() throws ResourceException {
        this.getVariants().add(new Variant(MediaType.TEXT_HTML));
        OsgiMonitorViewerApplication app = (OsgiMonitorViewerApplication)this.getApplication();
        BundleContext bundleContext = app.getBundleContext();
        this.bundles = bundleContext == null ? Collections.emptyList() : Arrays.asList(bundleContext.getBundles());
    }

    @Post
    public Representation install(String location) {
        String prefix = "prefix";
        if (!location.startsWith(prefix)) {
            return new StringRepresentation((CharSequence)("location didn't start with '" + prefix + "'"));
        }
        OsgiMonitorViewerApplication application = (OsgiMonitorViewerApplication)this.getApplication();
        return new StringRepresentation((CharSequence)"success");
    }

    private List<BundleDetails> allBundles() {
        ArrayList<BundleDetails> result = new ArrayList<BundleDetails>();
        for (Bundle bundle : this.bundles) {
            BundleDetails bundleDetail = new BundleDetails();
            bundleDetail.setSymbolicName(bundle.getLocation());
            bundleDetail.setBundleId(bundle.getBundleId());
            bundleDetail.setLastModified(bundle.getLastModified());
            bundleDetail.setRegisteredServices(this.getDetails(bundle.getRegisteredServices()));
            bundleDetail.setServicesInUse(this.getDetails(bundle.getServicesInUse()));
            bundleDetail.setState(bundle.getState());
            bundleDetail.setVersion(bundle.getVersion());
            bundleDetail.setSymbolicName(bundle.getSymbolicName());
            result.add(bundleDetail);
        }
        return result;
    }

    private Map<String, String> getDetails(Dictionary headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            Object nextElement = keys.nextElement();
            result.put(nextElement.toString(), headers.get(nextElement).toString());
        }
        return result;
    }

    private List<ServiceReferenceDetails> getDetails(ServiceReference[] registeredServices) {
        ArrayList<ServiceReferenceDetails> details = new ArrayList<ServiceReferenceDetails>();
        if (registeredServices == null) {
            return details;
        }
        for (ServiceReference serviceReference : registeredServices) {
            ServiceReferenceDetails srd = new ServiceReferenceDetails();
            srd.setBundleId(serviceReference.getBundle().getBundleId());
            srd.setName(serviceReference.toString());
            srd.setPropertyKeys(serviceReference.getPropertyKeys());
            srd.setUsingBundles(this.getDetails(serviceReference.getUsingBundles()));
            details.add(srd);
        }
        return details;
    }

    private List<BundleDetails> getDetails(Bundle[] usingBundles) {
        ArrayList<BundleDetails> details = new ArrayList<BundleDetails>();
        if (usingBundles == null) {
            return details;
        }
        for (Bundle bundle : usingBundles) {
            BundleDetails bundleDetails = new BundleDetails();
            bundleDetails.setBundleId(bundle.getBundleId());
            bundleDetails.setSymbolicName(bundle.getSymbolicName());
            bundleDetails.setVersion(bundle.getVersion());
            details.add(bundleDetails);
        }
        return details;
    }
}

