/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.server.ext.osgimonitor.test;

import de.twenty11.skysail.common.ext.osgimonitor.BundleDetails;
import de.twenty11.skysail.common.responses.Response;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorComponent;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorUrlMapper;
import de.twenty11.skysail.server.ext.osgimonitor.internal.OsgiMonitorViewerApplication;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.osgi.service.component.ComponentContext;
import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Restlet;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.security.MapVerifier;
import org.restlet.security.SecretVerifier;

public class BaseTests {
    protected OsgiMonitorViewerApplication osgiMonitorViewerApplication;
    protected Restlet inboundRoot;
    protected ObjectMapper mapper = new ObjectMapper();

    protected OsgiMonitorViewerApplication setUpRestletApplication(ComponentContext componentContext) throws ClassNotFoundException {
        MapVerifier secretVerifier = new MapVerifier();
        secretVerifier.getLocalSecrets().put("testadmin", "testpassword".toCharArray());
        OsgiMonitorComponent osgiMonitorComponent = new OsgiMonitorComponent(componentContext, (SecretVerifier)secretVerifier);
        this.osgiMonitorViewerApplication = osgiMonitorComponent.getApplication();
        Application.setCurrent((Application)this.osgiMonitorViewerApplication);
        this.inboundRoot = this.osgiMonitorViewerApplication.getInboundRoot();
        this.addMappings();
        return this.osgiMonitorViewerApplication;
    }

    protected void addMappings() throws ClassNotFoundException {
        Map urlMapping = new OsgiMonitorUrlMapper().provideUrlMapping();
        for (Map.Entry mapping : urlMapping.entrySet()) {
            Class<?> resourceClass = Class.forName((String)mapping.getValue());
            this.osgiMonitorViewerApplication.attachToRouter("" + (String)mapping.getKey(), resourceClass);
        }
    }

    protected List<BundleDetails> getBundles() throws Exception {
        org.restlet.Response response = this.get("bundles");
        this.assertDefaults(response);
        Representation entity = response.getEntity();
        System.out.println(entity.getText());
        Response skysailResponse = (Response)this.mapper.readValue(entity.getText(), (TypeReference)new TypeReference<Response<List<BundleDetails>>>(){});
        MatcherAssert.assertThat((String)skysailResponse.getMessage(), (Object)skysailResponse.getSuccess(), (Matcher)Matchers.is((Object)true));
        return (List)skysailResponse.getData();
    }

    private org.restlet.Response delete(String uri) {
        Request request = new Request(Method.DELETE, "/osgimonitor/" + uri);
        return this.handleRequest(request);
    }

    protected org.restlet.Response get(String uri) {
        Request request = new Request(Method.GET, "/osgimonitor/" + uri);
        return this.handleRequest(request);
    }

    protected org.restlet.Response post(String uri, Object connection) throws JsonGenerationException, JsonMappingException, IOException {
        Request request = new Request(Method.POST, "/osgimonitor/" + uri);
        String writeValueAsString = this.mapper.writeValueAsString(connection);
        request.setEntity(writeValueAsString, MediaType.APPLICATION_JSON);
        return this.handleRequest(request);
    }

    protected org.restlet.Response handleRequest(Request request) {
        ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, "testadmin", "testpassword");
        request.setChallengeResponse(authentication);
        org.restlet.Response response = new org.restlet.Response(request);
        this.inboundRoot.handle(request, response);
        return response;
    }

    protected void assertDefaults(org.restlet.Response response) {
        Assert.assertEquals((long)200L, (long)response.getStatus().getCode());
        MatcherAssert.assertThat((Object)response.isEntityAvailable(), (Matcher)Matchers.is((Object)true));
    }
}

