package de.twenty11.skysail.common.testing.utils;

import static org.ops4j.pax.exam.CoreOptions.mavenBundle;
import static org.ops4j.pax.exam.CoreOptions.systemProperty;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;

import org.ops4j.pax.exam.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This class defines the bundles (to be used by pax exam) skysail.common depends on.
 * 
 * Other XXXOsgiSetup classes can extend
 * 
 * @author carsten
 * 
 */
public class SkysailCommonOsgiSetup extends AbstractFrameworkIntegrationSetup {

    private static Logger logger = LoggerFactory.getLogger(SkysailCommonOsgiSetup.class.getName());

    @SuppressWarnings("deprecation")
    @Override
    public List<Option> getOptions(EnumSet<PaxExamOptionSet> optionSets) {

        List<Option> options = super.getOptions(optionSets);

        // needed for skysail.common (dependency)
        options.add(mavenBundle("commons-lang", "commons-lang", "2.6"));
        options.add(mavenBundle("log4j", "log4j", "1.2.17"));

        // options.add(mavenBundle("org.mockito", "mockito-all", "1.9.5"));

        // http://team.ops4j.org/wiki/display/paxurl/Mvn+Protocol#MvnProtocol-configuration
        // @formatter:off
        options.add(systemProperty("org.ops4j.pax.url.mvn.repositories").value(
                "https://repository.apache.org/content/repositories/releases@id=apache,"+
                "https://oss.sonatype.org/content/groups/public@id=sonatype,"+
                "https://repository.apache.org/content/groups/public/@id=apachegroups," +
                "https://maven.alfresco.com/nexus/content/groups/public/@id=afresco," +
                "http://download.eclipse.org/rt/eclipselink/maven.repo@id=eclipselink" +
                "http://repository.ops4j.org/maven2@id=ops4j"
        ));
        // @formatter:on
        // options.add(felix().version("4.0.3"));
        // options.add(equinox().version("3.6.2"));

        logger.info("using options from {} for tests", this.getClass());

        return options;
    }

    public void logOptionsUsed(Option[] options2Use) {
        for (Option option : options2Use) {
            logger.info(option.toString());
        }
    }

    // TODO not nice, resource clean up missing or broken
    public String getProjectVersion() {
        Properties props = new Properties();
        Reader fileReader = null;
        try {
            fileReader = new FileReader("project.properties");
            props.load(fileReader);
            return props.getProperty("project.version.from.pom");
        } catch (Exception e) {
            try {
                props.load(new FileReader("target/classes/project.properties"));
                return props.getProperty("project.version.from.pom");
            } catch (Exception e1) {
                e1.printStackTrace();
                return "unknownVersion";
            }
        } finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                } catch (IOException e) {
                    // cannot do anything
                }
            }
        }
    }

}
