package de.twenty11.skysail.common.testing.utils;

import static org.ops4j.pax.exam.Constants.START_LEVEL_SYSTEM_BUNDLES;
import static org.ops4j.pax.exam.Constants.START_LEVEL_TEST_BUNDLE;
import static org.ops4j.pax.exam.CoreOptions.bootDelegationPackage;
import static org.ops4j.pax.exam.CoreOptions.cleanCaches;
import static org.ops4j.pax.exam.CoreOptions.frameworkProperty;
import static org.ops4j.pax.exam.CoreOptions.frameworkStartLevel;
import static org.ops4j.pax.exam.CoreOptions.junitBundles;
import static org.ops4j.pax.exam.CoreOptions.mavenBundle;
import static org.ops4j.pax.exam.CoreOptions.systemProperty;
import static org.ops4j.pax.exam.CoreOptions.url;
import static org.ops4j.pax.exam.CoreOptions.when;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.util.PathUtils;

/**
 * see
 * https://github.com/ops4j/org.ops4j.pax.exam2/blob/a50c7f47f7467727bb99d23060c9cf2b4fac649b/itest/src/it/regression
 * -multi/src/test/java/org/ops4j/pax/exam/regression/multi/RegressionConfiguration.java copy most options from
 * PaxExamRuntime.defaultTestSystemOptions(), except RBC and Pax Logging
 * 
 * @author graefca
 * 
 */
@SuppressWarnings("deprecation")
public abstract class AbstractFrameworkIntegrationSetup implements PaxExamOptionsProvider {

    private static List<Option> defaultOptions = new ArrayList<Option>();

    static {

        defaultOptions.add(bootDelegationPackage("sun.*"));
        defaultOptions.add(cleanCaches());

        defaultOptions.add(url("link:classpath:META-INF/links/org.ops4j.pax.exam.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(url("link:classpath:META-INF/links/org.ops4j.pax.exam.inject.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(url("link:classpath:META-INF/links/org.ops4j.pax.extender.service.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(url("link:classpath:META-INF/links/org.ops4j.base.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(url("link:classpath:META-INF/links/org.ops4j.pax.swissbox.core.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(url("link:classpath:META-INF/links/org.ops4j.pax.swissbox.extender.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(url("link:classpath:META-INF/links/org.ops4j.pax.swissbox.lifecycle.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(url("link:classpath:META-INF/links/org.ops4j.pax.swissbox.framework.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(url("link:classpath:META-INF/links/org.apache.geronimo.specs.atinject.link").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));

        // add SLF4J and logback bundles
        defaultOptions.add(mavenBundle("org.slf4j", "slf4j-api", "1.6.1").startLevel(START_LEVEL_SYSTEM_BUNDLES)); // .versionAsInProject().);
        defaultOptions.add(mavenBundle("ch.qos.logback", "logback-core", "0.9.29").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));
        defaultOptions.add(mavenBundle("ch.qos.logback", "logback-classic", "0.9.29").startLevel(
                START_LEVEL_SYSTEM_BUNDLES));

        // add jcl-over-slf4j
        defaultOptions.add(mavenBundle("org.slf4j", "jcl-over-slf4j", "1.6.1").startLevel(START_LEVEL_SYSTEM_BUNDLES));

        // Set logback configuration via system property.
        // This way, both the driver and the container use the same configuration
        defaultOptions.add(systemProperty("logback.configurationFile").value(
                "file:" + PathUtils.getBaseDir() + "/src/test/resources/logback-test.xml"));

        // only for Pax Runner container
        defaultOptions.add(when("paxrunner".equals(System.getProperty("pax.exam.container")))
                .useOptions(
                        url("link:classpath:META-INF/links/org.ops4j.pax.exam.rbc.link").startLevel(
                                START_LEVEL_SYSTEM_BUNDLES),
                        mavenBundle("org.slf4j", "jcl-over-slf4j", "1.6.1").startLevel(START_LEVEL_SYSTEM_BUNDLES)));

        // not for Pax Runner container
        defaultOptions.add(when(!"paxrunner".equals(System.getProperty("pax.exam.container"))).useOptions(
                frameworkStartLevel(START_LEVEL_TEST_BUNDLE)));

        // junit
        defaultOptions.add(junitBundles());

        defaultOptions.add(frameworkProperty("osgi.console").value("6666"));
    }

    @Override
    public List<Option> getOptions(EnumSet<PaxExamOptionSet> optionSets) {
        if (optionSets.contains(PaxExamOptionSet.DEBUGGING)) {
            defaultOptions.add(mavenBundle("org.apache.felix", "org.apache.felix.log", "1.0.1"));
            defaultOptions.add(mavenBundle("org.apache.felix", "org.apache.felix.shell", "1.4.3"));
            defaultOptions.add(mavenBundle("org.apache.felix", "org.apache.felix.gogo.runtime", "0.10.0"));
            defaultOptions.add(mavenBundle("org.apache.felix", "org.apache.felix.gogo.shell", "0.10.0"));
            defaultOptions.add(mavenBundle("org.apache.felix", "org.apache.felix.gogo.command", "0.12.0"));
        }
        if (optionSets.contains(PaxExamOptionSet.SERVICES_VISUALIZATION)) {
            defaultOptions.add(mavenBundle("de.twentyeleven.skysail", "jgraphx-osgi", "1.10.3.1"));
            defaultOptions.add(mavenBundle("de.twentyeleven.skysail", "skysail.server.ext.osgideps", "0.0.1-SNAPSHOT")
                    .noStart());
        }
        return defaultOptions;
    }

}
