package de.twenty11.skysail.common.responses;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.restlet.data.Reference;

import de.twenty11.skysail.common.PresentationStyle;

/**
 * The kind of response to be used when the skysail server finds illegal input from the user (e.g. javascript for 
 * cross-side scripting attacks or the like).
 */
public class FoundIllegalInputResponse<T> extends SkysailResponse<T> {

    @JsonIgnore
    private Reference actionReference;

    public FoundIllegalInputResponse(T entity, Reference actionReference) {
        super();
        setSuccess(false);
        setMessage("Illigal Input found");
        setData(entity);
        setPresentationStyleHint(PresentationStyle.EDIT);
        this.actionReference = actionReference;
    }

    public Reference getActionReference() {
        return actionReference;
    }
}
