package de.twenty11.skysail.common.responses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.twenty11.skysail.common.forms.Field;

/**
 * A last type of Response is the FormResponse: You'd get it in case of an HTML - Request whenever you want to add an
 * entity or to display an existing one which you'd want to change.
 */
public class EntityDetailsResponse extends SkysailResponse<List<Map<String, String>>> {

    private final String target;
    private final Object entity;

    public EntityDetailsResponse(Object entity) {
        this(entity, null);
    }

    public EntityDetailsResponse(Object entity, String target) {
        this.entity = entity;
        this.target = target;
        setMessage("web form");
        setFields();
    }

    public String getTarget() {
        return target;
    }

    public Object getEntity() {
        return entity;
    }

    private void setFields() {
        List<Map<String, String>> data = new ArrayList<Map<String, String>>();

        List<java.lang.reflect.Field> fields = getInheritedFields(entity.getClass());
        for (java.lang.reflect.Field field : fields) {
            Field formField = field.getAnnotation(Field.class);
            if (formField == null) {
                continue;
            }

            Map<String, String> myField = new HashMap<String, String>();

            String value = "";
            try {
                field.setAccessible(true);
                Object object = field.get(entity);
                if (object instanceof String) {
                    value = (String) object;
                }
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            myField.put("id", field.getName());
            myField.put("inputtype", formField.inputtype());
            myField.put("tag", formField.tag());
            myField.put("value", value);
            myField.put("help", "");
            myField.put("css", "");

            data.add(myField);

            // if (violationsMap.containsKey(id)) {
            // // Object object = constraintViolations.
            // id = "inputError";
            // cssClass = "control-group error";
            // help = "<span class='help-inline'>" + violationsMap.get(field.getName()).getMessage() + "</span>";
            // }
            //
            // sb.append("<div class='" + cssClass + "'>\n");
            // sb.append("  <label class='control-label' for='" + id +
            // "'>").append(field.getName()).append("</label>\n");
            // sb.append("  <div class='controls'>\n");
            // sb.append("<input type='text' id='" + id + "' name='" + field.getName() + "' placeholder='' value='")
            // .append(value).append("'>\n");
            // sb.append(help);
            // sb.append("  </div>\n");
            // sb.append("</div>\n");

        }
        this.setData(data);
    }

    private List<java.lang.reflect.Field> getInheritedFields(Class<?> type) {
        List<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();

        Class<?> i = type;
        while (i != null && i != Object.class) {
            while (i != null && i != Object.class) {
                for (java.lang.reflect.Field field : i.getDeclaredFields()) {
                    if (!field.isSynthetic()) {
                        result.add(field);
                    }
                }
                i = i.getSuperclass();
            }
        }

        return result;
    }

}
