package de.twenty11.skysail.common.responses;

import java.util.HashSet;
import java.util.Set;

import javax.validation.ConstraintViolation;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.restlet.data.Reference;

import de.twenty11.skysail.common.PresentationStyle;

/**
 * Being a "business server", skysail has to deal with business requirements such as constraints (e.g. the field name
 * may not be empty). So when a user requests to add an entity which does not comply with the business rules, you should
 * not create a FailureResponse, but a ConstraintViolationResponse, containing information about the cause and the
 * rules. Skysail utilizes the javax.validation interfaces for this purpose.
 */
public class ConstraintViolationsResponse<T> extends SkysailResponse<T> {

    private Set<ConstraintViolationDetails> violations = new HashSet<ConstraintViolationDetails>();

    @JsonIgnore
    private Reference actionReference;

    public ConstraintViolationsResponse(T entity, Reference actionReference,
            Set<ConstraintViolation<T>> contraintViolations) {
        super();
        setSuccess(false);
        setData(entity);
        setPresentationStyleHint(PresentationStyle.EDIT);
        this.actionReference = actionReference;
        if (contraintViolations != null) {
            for (ConstraintViolation<T> constraintViolation : contraintViolations) {
                violations.add(new ConstraintViolationDetails(constraintViolation));
            }
        }
    }

    // public ConstraintViolationsResponse(T entity, Set<ConstraintViolation<T>> violations, ClientInfo clientInfo) {
    // super();
    // setSuccess(false);
    // setData(entity);
    // this.violations = violations;
    // setPresentationStyleHint(PresentationStyle.EDIT);
    // MediaType preferredMediaType = clientInfo.getPreferredMediaType(
    // Arrays.asList(MediaType.APPLICATION_JSON, MediaType.TEXT_HTML));
    // if (preferredMediaType.equals(MediaType.APPLICATION_JSON)) {
    // setPresentationStyleHint(Pre)
    // }
    // }

    public Set<ConstraintViolationDetails> getViolations() {
        return violations;
    }

    public Reference getActionReference() {
        return actionReference;
    }
}
