package de.twenty11.skysail.common.graphs;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.codehaus.jackson.annotate.JsonSubTypes;

@JsonSubTypes({ @org.codehaus.jackson.annotate.JsonSubTypes.Type(value = DefaultNodeProvider.class, name = "de.twenty11.skysail.common.graphs.DefaultNodeProvider") })
public class DefaultNodeProvider implements NodeProvider {

    private String nodeId;
    private String nodeLabel;
    private List<EdgeProvider> edges;
    
    public DefaultNodeProvider() {
    }

    @Override
    public String getNodeId() {
        return nodeId;
    }
    
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public String getNodeLabel() {
        return nodeLabel;
    }
    
    public void setNodeLabel(String nodeLabel) {
        this.nodeLabel = nodeLabel;
    }

    @Override
    public Map<String, String> getNodeProperties() {
        return Collections.emptyMap();
    }

    @Override
    public String getType() {
        return this.getClass().getCanonicalName();
    }


    @Override
    public List<EdgeProvider> getEdges() {
        return this.edges;
    }

    public void setEdges(List<EdgeProvider> edges) {
        this.edges = edges;
    }
    
}
