package de.twenty11.skysail.common.config;

/**
 * A configurationProvider provides configuration values for given keys.
 * 
 * Implementors might use different strategies to find the configuration values (utilizing files, system properties,
 * staging directories, etc, or combinations of those).
 * 
 * If a configuration provider is published as a OSGi service (from its containing bundle), the class
 * ServerConfigurationImpl in the skysail.server bundle will be able to utilize the configuration information (see file
 * ConfigAggregation.xml).
 * 
 */
public interface ConfigurationProvider {

    /**
     * @return the name of the configurationProvider for debug purposes.
     */
    String getName();

    /**
     * Returns the configuration value for a given key if existent.
     * 
     * @param key
     *            key to query for
     * @return the value for the given key or null
     */
    String getConfigForKey(String key);

}
