package de.twenty11.skysail.common;

import java.awt.Color;

public class PresentableHeader {

    private final String text;
    private final String link;
    private final String categoryText;
    private final Color categoryColor;
    private final String image;
    private final String linkTarget;

    public static class Builder {

        private final String text;

        private String link = null;
        private String categoryText = "";
        private Color categoryColor = null;
        private String image = "";

        private String linkTarget;

        public Builder(String text) {
            this.text = text != null ? text : "---";
        }

        /**
         * for example: "activiti/repository/" + id _blank _parent _self _top framename
         * 
         */
        public Builder setLink(String link, String target) {
            this.link = link;
            this.linkTarget = target;
            return this;
        }

        public Builder setLink(String link) {
            setLink(link, null);
            return this;
        }

        public Builder setCategoryText(String categoryText) {
            this.categoryText = categoryText;
            return this;
        }

        public Builder setCategoryColor(Color categoryColor) {
            this.categoryColor = categoryColor;
            return this;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        public PresentableHeader build() {
            return new PresentableHeader(this);
        }

    }

    private PresentableHeader(Builder builder) {
        text = builder.text;
        link = builder.link;
        linkTarget = builder.linkTarget;
        categoryText = builder.categoryText;
        categoryColor = builder.categoryColor;
        image = builder.image;
    }

    public String getText() {
        return text;
    }

    public String getLink() {
        if (link == null) {
            return null;
        }
        String target = linkTarget == null ? "" : "target='" + linkTarget + "' ";
        StringBuilder sb = new StringBuilder("<a href='" + link + "'").append(target).append(">").append(text)
                .append("</a>");
        return sb.toString();
    }

    public Color getCategoryColor() {
        return categoryColor;
    }

    public String getCategoryText() {
        return categoryText;
    }

    public String getImage() {
        return image;
    }

}
