/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common;

import de.twenty11.skysail.common.Presentable;
import de.twenty11.skysail.common.PresentableHeader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;

public class AbstractPresentable
implements Presentable {
    private Object instanceToInspect = null;

    @Override
    @JsonIgnore
    public PresentableHeader getHeader() {
        if (this.instanceToInspect == null) {
            throw new IllegalStateException("must set instanceToInspect before calling getHeader");
        }
        List<Method> getters = this.getGetters(this.instanceToInspect.getClass());
        for (Method method : getters) {
            if (method.getName().equals("getName")) {
                return this.invokeForHeader(method);
            }
            if (!method.getName().equals("getId")) continue;
            return this.invokeForHeader(method);
        }
        return new PresentableHeader.Builder(this.toString()).build();
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getContent() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Method> getters = this.getGetters(this.instanceToInspect.getClass());
        for (Method method : getters) {
            try {
                result.put(method.getName().substring(3), method.invoke(this.instanceToInspect, new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private List<Method> getGetters(Class<?> cls) {
        Method[] methods;
        ArrayList<Method> results = new ArrayList<Method>();
        for (Method method : methods = cls.getMethods()) {
            if (!method.getName().startsWith("get") || !method.getReturnType().equals(String.class) || method.getParameterTypes().length != 0) continue;
            results.add(method);
        }
        return results;
    }

    private PresentableHeader invokeForHeader(Method method) {
        try {
            String name = (String)method.invoke(this.instanceToInspect, new Object[0]);
            return new PresentableHeader.Builder(name).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setInstanceToInspect(Object instanceToInspect) {
        this.instanceToInspect = instanceToInspect;
    }
}

