/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.grids.Columns;
import de.twenty11.skysail.common.grids.RowData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonSetter;

public class GridData {
    private Columns columns;
    private final List<RowData> rows = new ArrayList<RowData>();
    private Integer availableRowsCount = 0;
    String type;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonCreator
    public GridData() {
    }

    public final void addRowData(RowData rowData) {
        Validate.notNull((Object)rowData);
        this.rows.add(rowData);
        Integer n = this.availableRowsCount;
        Integer n2 = this.availableRowsCount = Integer.valueOf(this.availableRowsCount + 1);
    }

    @JsonIgnore
    public final Integer getAvailableRowsCount() {
        return this.availableRowsCount;
    }

    @JsonIgnore
    public final Integer getColumnId(String key) {
        return this.columns.getColumnId(key);
    }

    public List<RowData> getRows() {
        return this.rows;
    }

    public void setSize(int size) {
    }

    public final String getSortingRepresentation() {
        return this.columns.getSortingRepresentation();
    }

    @JsonIgnore
    public void setSortingRepresentation(int sortingRep) {
    }

    public void removeRow(int j) {
        if (j < this.rows.size()) {
            this.rows.remove(j);
        }
    }

    @JsonSetter
    public void setColumns(Columns theColumns) {
        this.columns = theColumns;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availableRowsCount == null ? 0 : this.availableRowsCount.hashCode());
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.rows == null ? 0 : this.rows.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GridData)) {
            return false;
        }
        GridData other = (GridData)obj;
        if (this.availableRowsCountIsDifferent(other)) {
            return false;
        }
        if (this.columnsAreDifferent(other)) {
            return false;
        }
        return !this.rowsAreDifferent(other);
    }

    private boolean rowsAreDifferent(GridData other) {
        return this.rows == null ? other.rows != null : !this.rows.equals(other.rows);
    }

    private boolean columnsAreDifferent(GridData other) {
        return this.columns == null ? other.columns != null : !this.columns.equals(other.columns);
    }

    private boolean availableRowsCountIsDifferent(GridData other) {
        return this.availableRowsCount == null ? other.availableRowsCount != null : !this.availableRowsCount.equals(other.availableRowsCount);
    }
}

