/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common;

import java.awt.Color;

public class PresentableHeader {
    private final String text;
    private final String link;
    private final String categoryText;
    private final Color categoryColor;
    private final String image;
    private final String linkTarget;

    private PresentableHeader(Builder builder) {
        this.text = builder.text;
        this.link = builder.link;
        this.linkTarget = builder.linkTarget;
        this.categoryText = builder.categoryText;
        this.categoryColor = builder.categoryColor;
        this.image = builder.image;
    }

    public String getText() {
        return this.text;
    }

    public String getLink() {
        if (this.link == null) {
            return null;
        }
        String target = this.linkTarget == null ? "" : "target='" + this.linkTarget + "' ";
        StringBuilder sb = new StringBuilder("<a href='" + this.link + "'").append(target).append(">").append(this.text).append("</a>");
        return sb.toString();
    }

    public Color getCategoryColor() {
        return this.categoryColor;
    }

    public String getCategoryText() {
        return this.categoryText;
    }

    public String getImage() {
        return this.image;
    }

    public static class Builder {
        private final String text;
        private String link = null;
        private String categoryText = "";
        private Color categoryColor = null;
        private String image = "";
        private String linkTarget;

        public Builder(String text) {
            this.text = text != null ? text : "---";
        }

        public Builder setLink(String link, String target) {
            this.link = link;
            this.linkTarget = target;
            return this;
        }

        public Builder setLink(String link) {
            this.setLink(link, null);
            return this;
        }

        public Builder setCategoryText(String categoryText) {
            this.categoryText = categoryText;
            return this;
        }

        public Builder setCategoryColor(Color categoryColor) {
            this.categoryColor = categoryColor;
            return this;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        public PresentableHeader build() {
            return new PresentableHeader(this);
        }
    }
}

