/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.responses;

import de.twenty11.skysail.common.SkysailData;
import de.twenty11.skysail.common.grids.GridData;
import de.twenty11.skysail.common.maps.MapData;
import de.twenty11.skysail.common.navigation.Navigation;
import de.twenty11.skysail.common.pagination.Pagination;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class SkysailResponse<T extends SkysailData> {
    protected static ObjectMapper mapper = new ObjectMapper();
    private String message;
    private Boolean success = true;
    @JsonIgnore
    private Navigation navigation = new Navigation();
    private String filter;
    private T data = null;
    private Pagination pagination = new Pagination();
    private String sortingRepresentation;
    private Boolean debug = false;
    private final Set<String> paramsToStrip = new HashSet<String>();

    public SkysailResponse() {
        this.paramsToStrip.add("page");
        this.paramsToStrip.add("pageSize");
        this.paramsToStrip.add("toggleSorting");
        this.paramsToStrip.add("s");
    }

    public String asJson() throws JsonGenerationException, JsonMappingException, IOException {
        return mapper.writeValueAsString((Object)this);
    }

    public SkysailResponse<T> fromJson(String json, Class<? extends SkysailData> skysailData) throws JsonParseException, JsonMappingException, IOException {
        if (skysailData.equals(MapData.class)) {
            return (SkysailResponse)mapper.readValue(json, (TypeReference)new TypeReference<SkysailResponse<MapData>>(){});
        }
        if (skysailData.equals(GridData.class)) {
            return (SkysailResponse)mapper.readValue(json, (TypeReference)new TypeReference<SkysailResponse<GridData>>(){});
        }
        return null;
    }

    public final Boolean getSuccess() {
        return this.success;
    }

    public final void setSuccess(Boolean successful) {
        this.success = successful;
    }

    public void setDebug(Boolean shouldDebug) {
        this.debug = shouldDebug;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setRequest(String origRequest) {
        String url = this.stripDoubleAndEmptyParameters(origRequest);
        if (url == null) {
            return;
        }
        url = this.checkLastCharacter(url);
        for (String paramName : this.paramsToStrip) {
            url = url.replaceAll(paramName + "=[^&]*&?", "");
        }
        if (url.contains("?") && !url.endsWith("?")) {
            url = url + "&";
        } else if (!url.contains("?")) {
            url = url + "?";
        }
        this.navigation.setRequest(url);
    }

    private String checkLastCharacter(String url) {
        Validate.notNull((Object)url);
        String result = url;
        if (url.endsWith("?")) {
            result = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("&")) {
            result = url.substring(0, url.length() - 1);
        }
        return result;
    }

    private String stripDoubleAndEmptyParameters(String req) {
        if (req == null) {
            return null;
        }
        String[] reqSplit = req.split("\\?");
        if (reqSplit.length <= 1) {
            return req;
        }
        String query = reqSplit[1];
        String[] parameterPairs = query.split("&");
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String parameterPair : parameterPairs) {
            String[] split = parameterPair.split("=");
            parameterMap.put(split[0], split.length > 1 ? split[1] : "");
        }
        StringBuffer sb = new StringBuffer(reqSplit[0] + "?");
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).trim().equals("")) continue;
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        return sb.toString();
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String msg) {
        this.message = msg;
    }

    public T getData() {
        return this.data;
    }

    public final void setData(T mydata) {
        this.data = mydata;
    }

    public void setParent(String url) {
        this.navigation.setParent(url);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @JsonIgnore
    public String getFilter() {
        return this.filter;
    }

    public void setContextPath(String path) {
        this.navigation.setContextPath(path);
    }

    public String getContextPath() {
        return this.navigation.getContextPath();
    }

    @JsonIgnore
    public Pagination getPagination() {
        return this.pagination;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public void setSortingRepresentation(String sorting) {
        this.sortingRepresentation = sorting;
    }

    public String getSortingRepresentation() {
        return this.sortingRepresentation;
    }

    public void setPageSize(int i) {
        this.pagination.setPageSize(i);
    }

    public void setPage(int i) {
        this.pagination.setPage(i);
    }

    public void setTotalResults(int i) {
        this.pagination.setTotalResults(i);
    }
}

