/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.internal.filters;

import de.twenty11.skysail.common.filters.Filter;
import de.twenty11.skysail.common.filters.FilterType;
import de.twenty11.skysail.common.filters.LdapSearchFilter;
import java.util.ArrayList;

public class FilterExpressionParser {
    private static final String COULD_NOT_PARSE_FILTER_EXPRESSION = "could not parse filter expression ";
    private final String filterExpression;
    private final char[] filterChars;
    private int position = 1;

    public FilterExpressionParser(String filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter expression is null");
        }
        if (filter.trim().length() == 0) {
            throw new IllegalArgumentException("filter expression is empty");
        }
        this.filterExpression = filter.replaceAll("\\s+", "");
        this.filterChars = this.filterExpression.toCharArray();
    }

    public LdapSearchFilter parse() {
        if (this.filterExpression.charAt(0) != '(') {
            throw new IllegalArgumentException("filter expression '" + this.filterExpression + "' doesn't start with '('");
        }
        if (!this.filterExpression.endsWith(")")) {
            throw new IllegalArgumentException("filter expression '" + this.filterExpression + "' doesn't end with ')'");
        }
        return this.parseFiltercomp();
    }

    private LdapSearchFilter parseFiltercomp() {
        switch (this.filterChars[this.position]) {
            case '&': {
                ++this.position;
                return this.parseAnd();
            }
            case '|': {
                ++this.position;
                return this.parseOr();
            }
            case '!': {
                ++this.position;
                return this.parseNot();
            }
        }
        return this.parseItem();
    }

    private LdapSearchFilter parseAnd() {
        ArrayList<Filter> subfilters = new ArrayList<Filter>(10);
        while (this.filterChars[this.position] == '(') {
            LdapSearchFilter child = this.parse();
            subfilters.add(child);
        }
        return new LdapSearchFilter(FilterType.AND, null, subfilters);
    }

    private LdapSearchFilter parseOr() {
        ArrayList<Filter> subfilters = new ArrayList<Filter>(10);
        while (this.filterChars[this.position] == '(') {
            LdapSearchFilter child = this.parse();
            subfilters.add(child);
        }
        return new LdapSearchFilter(FilterType.OR, null, subfilters);
    }

    private LdapSearchFilter parseNot() {
        LdapSearchFilter child = this.parse();
        return new LdapSearchFilter(FilterType.NOT, null, child);
    }

    private LdapSearchFilter parseItem() {
        String attr = this.parseAttribute();
        switch (this.filterChars[this.position]) {
            case '>': {
                if (this.filterChars[this.position + 1] != '=') break;
                this.position += 2;
                return new LdapSearchFilter(FilterType.GREATER_OR_EQUAL, attr, this.parseValue());
            }
            case '<': {
                if (this.filterChars[this.position + 1] != '=') break;
                this.position += 2;
                return new LdapSearchFilter(FilterType.LESS_OR_EQUAL, attr, this.parseValue());
            }
            case '=': {
                if (this.filterChars[this.position + 1] == '*') {
                    int oldpos = this.position;
                    this.position += 2;
                    if (this.filterChars[this.position] == ')') {
                        return new LdapSearchFilter(FilterType.PRESENT, attr);
                    }
                    this.position = oldpos;
                }
                ++this.position;
                Object string = this.parseSubstring();
                if (string instanceof String) {
                    return new LdapSearchFilter(FilterType.EQUALITY_MATCH, attr, (String)string);
                }
                return new LdapSearchFilter(FilterType.SUBSTRINGS, attr, string);
            }
            default: {
                throw new IllegalArgumentException("unknown attribute '" + this.filterChars[this.position] + "' for LdapSearchFilter");
            }
        }
        throw new IllegalArgumentException(COULD_NOT_PARSE_FILTER_EXPRESSION + this.filterExpression);
    }

    private String parseAttribute() {
        int begin = this.position;
        int end = this.position;
        char c = this.filterChars[this.position];
        while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
            ++this.position;
            if (!Character.isWhitespace(c)) {
                end = this.position;
            }
            c = this.filterChars[this.position];
        }
        int length = end - begin;
        if (length == 0) {
            throw new IllegalArgumentException(COULD_NOT_PARSE_FILTER_EXPRESSION + this.filterExpression);
        }
        return new String(this.filterChars, begin, length);
    }

    private String parseValue() {
        StringBuffer sb = new StringBuffer(this.filterChars.length - this.position);
        block5: while (true) {
            char c = this.filterChars[this.position];
            switch (c) {
                case ')': {
                    break block5;
                }
                case '(': {
                    throw new IllegalArgumentException(COULD_NOT_PARSE_FILTER_EXPRESSION + this.filterExpression);
                }
                case '\\': {
                    ++this.position;
                    c = this.filterChars[this.position];
                    sb.append(c);
                    ++this.position;
                    continue block5;
                }
                default: {
                    sb.append(c);
                    ++this.position;
                    continue block5;
                }
            }
            break;
        }
        if (sb.length() == 0) {
            throw new IllegalArgumentException(COULD_NOT_PARSE_FILTER_EXPRESSION + this.filterExpression);
        }
        return sb.toString();
    }

    private Object parseSubstring() {
        Object single;
        int size;
        StringBuffer sb = new StringBuffer(this.filterChars.length - this.position);
        ArrayList<String> operands = new ArrayList<String>(10);
        block6: while (true) {
            char c = this.filterChars[this.position];
            switch (c) {
                case ')': {
                    if (sb.length() <= 0) break block6;
                    operands.add(sb.toString());
                    break block6;
                }
                case '(': {
                    throw new IllegalArgumentException(COULD_NOT_PARSE_FILTER_EXPRESSION + this.filterExpression);
                }
                case '*': {
                    if (sb.length() > 0) {
                        operands.add(sb.toString());
                    }
                    sb.setLength(0);
                    operands.add(null);
                    ++this.position;
                    continue block6;
                }
                case '\\': {
                    ++this.position;
                    c = this.filterChars[this.position];
                    sb.append(c);
                    ++this.position;
                    continue block6;
                }
                default: {
                    sb.append(c);
                    ++this.position;
                    continue block6;
                }
            }
            break;
        }
        if ((size = operands.size()) == 0) {
            return "";
        }
        if (size == 1 && (single = operands.get(0)) != null) {
            return single;
        }
        return operands.toArray(new String[size]);
    }
}

