/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.grids.ColumnDefinition;
import de.twenty11.skysail.common.grids.Columns;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.annotate.JsonIgnore;

public class RowData
implements Serializable {
    private static final long serialVersionUID = -8906891746212796759L;
    private Map<String, String> cells = new HashMap<String, String>();
    @JsonIgnore
    private ColumnDefinition[] columnsAsArray;
    @JsonIgnore
    private Map<ColumnDefinition, Object> columnDataMap = new LinkedHashMap<ColumnDefinition, Object>();
    private int columnCounter = 0;

    public RowData() {
    }

    public RowData(Columns cols) {
        Validate.notNull((Object)cols);
        this.columnsAsArray = cols.getAsList().toArray(new ColumnDefinition[cols.getAsList().size()]);
    }

    public RowData add(Object data) {
        if (this.columnCounter >= this.columnsAsArray.length) {
            throw new IllegalStateException("method add cannot be called " + (this.columnCounter + 1) + " times if there are only " + this.columnCounter + " columns defined");
        }
        ColumnDefinition columnDefinition = this.columnsAsArray[this.columnCounter++];
        this.columnDataMap.put(columnDefinition, data);
        this.cells.put(columnDefinition.getName(), data.toString());
        return this;
    }

    public void add(Object data, String defaultString) {
        if (defaultString == null) {
            throw new IllegalArgumentException("add(Object,String) in RowData may not be called with null value for String");
        }
        if (data == null) {
            this.add(defaultString);
        } else {
            this.add(data);
        }
    }

    public Map<String, String> getCells() {
        return this.cells;
    }

    public void setCells(Map<String, String> props) {
        Validate.notNull(props);
        this.cells = props;
        this.columnDataMap.clear();
        this.columnsAsArray = new ColumnDefinition[props.size()];
        this.columnCounter = props.size();
        int i = 0;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            ColumnDefinition colDef = new ColumnDefinition(entry.getKey());
            this.columnDataMap.put(colDef, entry.getValue());
            this.columnsAsArray[i++] = colDef;
        }
    }

    @JsonIgnore
    public List<Object> getColumnData() {
        return new ArrayList<Object>(this.columnDataMap.values());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RowData [current Col: ").append(this.columnCounter).append(", max columns#=").append(this.columnsAsArray.length);
        for (Object colData : this.getColumnData()) {
            sb.append("\n  (").append(colData).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cells == null ? 0 : ((Object)this.cells).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowData)) {
            return false;
        }
        RowData other = (RowData)obj;
        return !(this.getCells() == null ? other.getCells() != null : !((Object)this.getCells()).equals(other.getCells()));
    }
}

