/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.SkysailData;
import de.twenty11.skysail.common.filters.AndFilter;
import de.twenty11.skysail.common.filters.Filter;
import de.twenty11.skysail.common.filters.FilterType;
import de.twenty11.skysail.common.grids.Columns;
import de.twenty11.skysail.common.grids.ColumnsBuilder;
import de.twenty11.skysail.common.grids.RowData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonSetter;

public class GridData
implements SkysailData {
    private static final long serialVersionUID = 3808733942569990251L;
    private Columns columns;
    private final List<RowData> rows = new ArrayList<RowData>();
    private Filter filter = new AndFilter(FilterType.EMPTY);
    private Integer availableRowsCount = 0;

    @JsonCreator
    public GridData() {
    }

    public GridData(ColumnsBuilder builder) {
        this.columns = new Columns(builder);
    }

    public final void addRowData(RowData rowData) {
        Validate.notNull((Object)rowData);
        if (this.filter == null || this.filter.match(rowData.getCells())) {
            this.rows.add(rowData);
            Integer n = this.availableRowsCount;
            Integer n2 = this.availableRowsCount = Integer.valueOf(this.availableRowsCount + 1);
        }
    }

    @JsonIgnore
    public final Integer getAvailableRowsCount() {
        return this.availableRowsCount;
    }

    @JsonIgnore
    public final Integer getColumnId(String key) {
        return this.columns.getColumnId(key);
    }

    public Columns getColumns() {
        return this.columns;
    }

    @JsonIgnore
    public Filter getFilter() {
        return this.filter;
    }

    public Object getGridElement(int row, int col) {
        if (this.rows == null) {
            throw new IllegalArgumentException("trying to access row " + row + " of rows which is null");
        }
        if (this.rows.size() < row) {
            throw new IllegalArgumentException("trying to access row " + row + " of rows with size of " + this.rows.size());
        }
        List<Object> columnData = this.rows.get(row).getColumnData();
        if (columnData.size() < col) {
            throw new IllegalArgumentException("trying to access column " + col + " of grids row with size of " + columnData.size());
        }
        return this.rows.get(row).getColumnData().get(col);
    }

    public List<RowData> getRows() {
        return this.rows;
    }

    @Override
    public int getSize() {
        return this.rows.size();
    }

    public void setSize(int size) {
    }

    public final String getSortingRepresentation() {
        return this.columns.getSortingRepresentation();
    }

    @JsonIgnore
    public void setSortingRepresentation(int sortingRep) {
    }

    public void removeRow(int j) {
        if (j < this.rows.size()) {
            this.rows.remove(j);
        }
    }

    @JsonSetter
    public void setColumns(Columns theColumns) {
        this.columns = theColumns;
    }

    @JsonIgnore
    public void setColumns(ColumnsBuilder builder) {
        this.columns = new Columns(builder);
    }

    @JsonIgnore
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GridData {\n");
        if (this.columns != null) {
            sb.append(this.columns.toString());
        }
        if (this.rows != null) {
            sb.append("  GridData (").append(this.getSize()).append("): ");
            for (RowData row : this.rows) {
                sb.append(row).append(",");
            }
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availableRowsCount == null ? 0 : this.availableRowsCount.hashCode());
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.rows == null ? 0 : ((Object)this.rows).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GridData)) {
            return false;
        }
        GridData other = (GridData)obj;
        if (this.availableRowsCountIsDifferent(other)) {
            return false;
        }
        if (this.columnsAreDifferent(other)) {
            return false;
        }
        return !this.rowsAreDifferent(other);
    }

    private boolean rowsAreDifferent(GridData other) {
        return this.rows == null ? other.rows != null : !((Object)this.rows).equals(other.rows);
    }

    private boolean columnsAreDifferent(GridData other) {
        return this.columns == null ? other.columns != null : !this.columns.equals(other.columns);
    }

    private boolean availableRowsCountIsDifferent(GridData other) {
        return this.availableRowsCount == null ? other.availableRowsCount != null : !this.availableRowsCount.equals(other.availableRowsCount);
    }
}

