/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.grids.ColumnDefinition;
import de.twenty11.skysail.common.grids.ColumnSortOrderComparator;
import de.twenty11.skysail.common.grids.ColumnsBuilder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class Columns {
    private List<ColumnDefinition> columnsList;
    private String sortingRepresentation;

    public Columns(ColumnsBuilder builder) {
        Validate.notNull((Object)builder);
        this.columnsList = builder.getColumns();
    }

    public Columns() {
    }

    @JsonIgnore
    public final List<ColumnDefinition> getColumnsInSortOrder() {
        LinkedList<ColumnDefinition> copyForSorting = new LinkedList<ColumnDefinition>();
        if (this.columnsList != null) {
            for (ColumnDefinition columnDefinition : this.columnsList) {
                copyForSorting.add(columnDefinition);
            }
            Collections.sort(copyForSorting, new ColumnSortOrderComparator());
        }
        return copyForSorting;
    }

    public void setColumnsList(List<ColumnDefinition> theColumns) {
        this.columnsList = theColumns;
    }

    @JsonIgnore
    public int getMaxSortValueFromBuilder() {
        List<ColumnDefinition> sortedColumns = this.getColumnsInSortOrder();
        ColumnDefinition[] columnsAsArray = sortedColumns.toArray(new ColumnDefinition[sortedColumns.size()]);
        if (columnsAsArray.length == 0) {
            return 0;
        }
        Integer maxSorting = columnsAsArray[sortedColumns.size() - 1].getSorting();
        return maxSorting != null ? Math.abs(maxSorting) : 0;
    }

    public List<ColumnDefinition> sort(String sortingInstructionFromRequest, Integer colIdToToggle) {
        this.validate(sortingInstructionFromRequest, this.columnsList.size());
        TreeMap<Integer, Integer> sortingMap = new TreeMap<Integer, Integer>();
        List<ColumnDefinition> preSortedColumns = this.getColumnsInSortOrder();
        for (ColumnDefinition currentColumn : preSortedColumns) {
            this.setSortingAsByRequest(sortingMap, sortingInstructionFromRequest, currentColumn);
        }
        ColumnDefinition columnToToggle = this.getColumnDefinitionToToggle(preSortedColumns, colIdToToggle);
        int maxSortWeight = this.getMaxSortValueFromBuilder();
        if (columnToToggle != null) {
            this.toggleColumnsSorting(maxSortWeight, sortingMap, columnToToggle);
        }
        this.sortingRepresentation = this.calcSortingRepresentation(sortingMap);
        Collections.sort(preSortedColumns, new ColumnSortOrderComparator());
        return preSortedColumns;
    }

    private void toggleColumnsSorting(int maxSortValue, Map<Integer, Integer> sortingMap, ColumnDefinition columnToToggle) {
        Integer sorting = columnToToggle.getSorting();
        if (sorting > 0) {
            columnToToggle.sortAsc(maxSortValue + 1);
            sortingMap.put(this.getColumnId(columnToToggle.getName()), -(maxSortValue + 1));
        } else if (sorting == 0) {
            columnToToggle.sortDesc(maxSortValue + 1);
            sortingMap.put(this.getColumnId(columnToToggle.getName()), maxSortValue + 1);
        } else {
            columnToToggle.sortDesc(0);
            sortingMap.put(this.getColumnId(columnToToggle.getName()), 0);
        }
    }

    private void validate(String override, int size) {
        if (override == null || override.trim().equals("")) {
            return;
        }
        String[] sortValuesFromRequest = override.split("\\|");
        if (sortValuesFromRequest.length != size) {
            throw new IllegalArgumentException("parameter 's' for sorting has " + sortValuesFromRequest.length + "parts, but should have " + size);
        }
        for (String part : sortValuesFromRequest) {
            try {
                Integer.valueOf(part);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("could not parse '" + part + "' of sorting parameter " + override + " as Integer");
            }
        }
    }

    private ColumnDefinition getColumnDefinitionToToggle(List<ColumnDefinition> columnsInSortOrder, Integer columnId) {
        if (columnId == null) {
            return null;
        }
        String columnNameToToggle = this.getColumnName(columnId);
        for (ColumnDefinition columnDefinition : columnsInSortOrder) {
            if (!columnDefinition.getName().equals(columnNameToToggle)) continue;
            return columnDefinition;
        }
        return null;
    }

    private void setSortingAsByRequest(Map<Integer, Integer> sortingMap, String override, ColumnDefinition currentColumn) {
        Validate.notNull((Object)currentColumn);
        Integer sorting = currentColumn.getSorting();
        Integer columnId = this.getColumnId(currentColumn.getName());
        if (override != null && override.trim().length() > 0) {
            String[] sortValuesFromRequest = override.split("\\|");
            sorting = Integer.valueOf(sortValuesFromRequest[columnId]);
        }
        sortingMap.put(columnId, sorting);
    }

    @JsonProperty(value="columnsList")
    public List<ColumnDefinition> getAsList() {
        return this.columnsList;
    }

    @JsonIgnore
    public String getSortingRepresentation() {
        return this.sortingRepresentation;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  Columns (").append(this.columnsList.size()).append("): ");
        for (ColumnDefinition col : this.columnsList) {
            sb.append(col).append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    public final String getColumnName(Integer key) {
        return this.columnsList.get(key).getName();
    }

    public Integer getColumnId(String columnName) {
        Validate.notNull((Object)columnName);
        for (int i = 0; i < this.columnsList.size(); ++i) {
            ColumnDefinition column = this.columnsList.get(i);
            if (!column.getName().equals(columnName)) continue;
            return i;
        }
        return null;
    }

    private String calcSortingRepresentation(Map<Integer, Integer> sortingMap) {
        Validate.notNull(sortingMap);
        String sortingString = "";
        if (sortingMap.size() > 0) {
            StringBuffer sb = new StringBuffer("s=");
            for (Map.Entry<Integer, Integer> entry : sortingMap.entrySet()) {
                sb.append(entry.getValue() != null ? entry.getValue() + "|" : "0|");
            }
            sortingString = sb.toString().substring(0, sb.length() - 1) + "&";
        }
        return sortingString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnsList == null ? 0 : ((Object)this.columnsList).hashCode());
        result = 31 * result + (this.sortingRepresentation == null ? 0 : this.sortingRepresentation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Columns)) {
            return false;
        }
        Columns other = (Columns)obj;
        if (this.columnsList == null ? other.columnsList != null : !((Object)this.columnsList).equals(other.columnsList)) {
            return false;
        }
        return !(this.sortingRepresentation == null ? other.sortingRepresentation != null : !this.sortingRepresentation.equals(other.sortingRepresentation));
    }
}

