/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.filters.Filter;
import java.io.Serializable;

public class ColumnDefinition
implements Serializable {
    private static final long serialVersionUID = 7871296812642842749L;
    private String name;
    private Integer width = null;
    private Integer sorting = 0;
    private String filterValue = "";

    public ColumnDefinition() {
    }

    public ColumnDefinition(String columnName) {
        this.name = columnName;
    }

    public final void apply(Filter filter) {
        if (filter != null) {
            this.filterValue = filter.getValue(this.name);
        }
    }

    public final ColumnDefinition sortDesc(Integer weight) {
        this.sorting = null;
        if (weight != null) {
            this.sorting = Math.abs(weight);
        }
        return this;
    }

    public final ColumnDefinition sortAsc(Integer weight) {
        this.sorting = null;
        if (weight != null) {
            this.sorting = -Math.abs(weight);
        }
        return this;
    }

    public final ColumnDefinition setWidth(Integer colWidth) {
        this.width = colWidth;
        return this;
    }

    public final Integer getWidth() {
        return this.width;
    }

    public final String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String filter) {
        this.filterValue = filter;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public final String getName() {
        return this.name;
    }

    public final Integer getSorting() {
        return this.sorting;
    }

    public void setSorting(Integer theSorting) {
        this.sorting = theSorting;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer("ColumnDefinition: {");
        sb.append("Name: ").append(this.name);
        sb.append(", Width: ").append(this.width);
        sb.append(", Sorting: ").append(this.sorting);
        sb.append(", Filter: '").append(this.filterValue).append("'}\n");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filterValue == null ? 0 : this.filterValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sorting == null ? 0 : this.sorting.hashCode());
        result = 31 * result + (this.width == null ? 0 : this.width.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition)obj;
        if (this.filterValue == null ? other.filterValue != null : !this.filterValue.equals(other.filterValue)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.sorting == null ? other.sorting != null : !this.sorting.equals(other.sorting)) {
            return false;
        }
        return !(this.width == null ? other.width != null : !this.width.equals(other.width));
    }
}

