/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.test;

import de.twenty11.skysail.common.grids.GridData;
import de.twenty11.skysail.common.responses.SkysailFailureResponse;
import de.twenty11.skysail.common.responses.SkysailResponse;
import de.twenty11.skysail.common.responses.SkysailSuccessResponse;
import java.net.MalformedURLException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SkysailResponseTest {
    private SkysailResponse<GridData> response;

    @Before
    public void setUp() throws Exception {
        this.response = new SkysailResponse();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testRequestHandling1() throws MalformedURLException {
        this.response.setRequest("http://localhost:8099/rest/services/");
        String alteredRequest = this.response.getNavigation().getRequest();
        Assert.assertTrue((boolean)alteredRequest.equals("http://localhost:8099/rest/services/?"));
    }

    @Test
    public void testRequestHandling2() throws MalformedURLException {
        this.response.setRequest("http://localhost:8099/rest/services/?");
        String alteredRequest = this.response.getNavigation().getRequest();
        Assert.assertTrue((boolean)alteredRequest.equals("http://localhost:8099/rest/services/?"));
    }

    @Test
    public void testRequestHandling3() throws MalformedURLException {
        this.response.setRequest("http://localhost:8099/rest/services/?page=2");
        String alteredRequest = this.response.getNavigation().getRequest();
        Assert.assertTrue((boolean)alteredRequest.equals("http://localhost:8099/rest/services/?"));
    }

    @Test
    public void testSuccessResponse() {
        SkysailSuccessResponse successResponse = new SkysailSuccessResponse();
        Assert.assertTrue((boolean)successResponse.getSuccess());
    }

    @Test
    public void testFailureResponse() {
        SkysailFailureResponse failureResponse = new SkysailFailureResponse();
        Assert.assertFalse((boolean)failureResponse.getSuccess());
    }

    @Test
    public void testSerializationOfFailureResponse() throws Exception {
        SkysailFailureResponse failureResponse = new SkysailFailureResponse();
        failureResponse.setMessage("error");
        String serialized = failureResponse.asJson();
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.containsString((String)"\"success\":false"));
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.containsString((String)"\"message\":\"error\""));
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.containsString((String)"\"debug\":false"));
    }
}

