/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.responses;

import de.twenty11.skysail.common.SkysailData;
import de.twenty11.skysail.common.maps.MapData;
import de.twenty11.skysail.common.responses.SkysailFailureResponse;
import de.twenty11.skysail.common.responses.SkysailResponse;
import de.twenty11.skysail.common.responses.SkysailSuccessResponse;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class MapDataJsonTests {
    private ObjectMapper mapper = new ObjectMapper();
    private SkysailResponse<MapData> failureResponse;
    private SkysailResponse<MapData> successResponse;

    @Before
    public void setUp() throws Exception {
        this.failureResponse = new SkysailFailureResponse();
        this.failureResponse.setMessage("error");
        this.successResponse = new SkysailSuccessResponse();
        this.successResponse.setMessage("mymsg");
        MapData mydata = new MapData();
        mydata.put("key", "value");
        mydata.put("key2", "value2");
        this.successResponse.setData((SkysailData)mydata);
    }

    @Test
    public void testSerializationOfFailureResponse() throws JsonGenerationException, JsonMappingException, IOException {
        String strRep = this.failureResponse.asJson();
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"success\":false"));
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"message\":\"error\""));
    }

    @Test
    public void testSerializationOfSuccessResponse() throws JsonGenerationException, JsonMappingException, IOException {
        String strRep = this.successResponse.asJson();
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"success\":true"));
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"message\":\"mymsg\""));
    }

    @Test
    public void testDeserializationOfFailureResponse() throws Exception {
        String strRep = this.failureResponse.asJson();
        SkysailResponse deserialized = this.failureResponse.fromJson(strRep, MapData.class);
        MapData payload = (MapData)deserialized.getData();
        MatcherAssert.assertThat((Object)deserialized.getMessage(), (Matcher)Matchers.is((Object)"error"));
        MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testDeserializationOfSuccessResponse() throws Exception {
        String strRep = this.mapper.writeValueAsString(this.successResponse);
        SkysailResponse deserialized = this.successResponse.fromJson(strRep, MapData.class);
        MapData payload = (MapData)deserialized.getData();
        MatcherAssert.assertThat((Object)deserialized.getMessage(), (Matcher)Matchers.is((Object)"mymsg"));
        MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }
}

