/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.responses;

import de.twenty11.skysail.common.SkysailData;
import de.twenty11.skysail.common.grids.GridData;
import de.twenty11.skysail.common.responses.SkysailFailureResponse;
import de.twenty11.skysail.common.responses.SkysailResponse;
import de.twenty11.skysail.common.responses.SkysailSuccessResponse;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class GridDataJsonTests {
    private ObjectMapper mapper = new ObjectMapper();
    private SkysailResponse<GridData> failureResponse;
    private SkysailResponse<GridData> successResponse;

    @Before
    public void setUp() throws Exception {
        this.failureResponse = new SkysailFailureResponse();
        this.failureResponse.setMessage("error");
        this.successResponse = new SkysailSuccessResponse();
        this.successResponse.setMessage("mymsg");
        GridData data = new GridData();
        this.successResponse.setData((SkysailData)data);
    }

    @Test
    public void testSerializationOfFailureResponse() throws JsonGenerationException, JsonMappingException, IOException {
        String strRep = this.mapper.writeValueAsString(this.failureResponse);
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"success\":false"));
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"message\":\"error\""));
    }

    @Test
    public void testSerializationOfSuccessResponse() throws JsonGenerationException, JsonMappingException, IOException {
        String strRep = this.mapper.writeValueAsString(this.successResponse);
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"success\":true"));
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"message\":\"mymsg\""));
    }

    @Test
    public void testDeserializationOfFailureResponse() throws Exception {
        String strRep = this.mapper.writeValueAsString(this.failureResponse);
        SkysailResponse deserialized = this.failureResponse.fromJson(strRep, GridData.class);
        GridData payload = (GridData)deserialized.getData();
        MatcherAssert.assertThat((Object)deserialized.getMessage(), (Matcher)Matchers.is((Object)"error"));
        MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testDeserializationOfSuccessResponse() throws Exception {
        String strRep = this.mapper.writeValueAsString(this.successResponse);
        SkysailResponse deserialized = this.successResponse.fromJson(strRep, GridData.class);
        GridData payload = (GridData)deserialized.getData();
        MatcherAssert.assertThat((Object)deserialized.getMessage(), (Matcher)Matchers.is((Object)"mymsg"));
        MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }
}

