/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.maps.test;

import de.twenty11.skysail.common.maps.MapData;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MapDataTest {
    private ObjectMapper mapper = new ObjectMapper();
    private MapData mapData;

    @Before
    public void setUp() throws Exception {
        this.mapData = new MapData();
        this.mapData.put("key", "value");
    }

    @Test
    public void addingNewEntryShouldIncreaseSizeByOne() throws Exception {
        Assert.assertThat((Object)this.mapData.getSize(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void addingExistingEntryShouldNotIncreaseSizeButUpdateValue() throws Exception {
        MapData mapData = new MapData();
        mapData.put("key", "value");
        mapData.put("key", "value2");
        Assert.assertThat((Object)mapData.getSize(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)mapData.getValue("key"), (Matcher)Matchers.is((Object)"value2"));
    }

    @Test
    public void shouldSucceedWhenSerializingToJson() throws Exception {
        String strRep = this.mapper.writeValueAsString((Object)this.mapData);
        Assert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"key\":\"value\""));
    }

    @Test
    public void shouldSucceedWhenDeserializingFromJson() throws Exception {
        String strRep = this.mapper.writeValueAsString((Object)this.mapData);
        Object readValue = this.mapper.readValue(strRep, MapData.class);
    }
}

