/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.filters.AndFilter;
import de.twenty11.skysail.common.grids.ColumnsBuilder;
import de.twenty11.skysail.common.grids.GridData;
import de.twenty11.skysail.common.grids.RowData;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridDataTest {
    private GridData gridData;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("col1", "match");
        this.gridData = new GridData(new ColumnsBuilder(){

            public void configure() {
                this.addColumn("col1");
                this.addColumn("col2");
            }
        });
        this.gridData.setFilter(AndFilter.newInstance(parameters));
    }

    @Test
    public void testAddRowData() {
        RowData rowData = new RowData(this.gridData.getColumns());
        rowData.add((Object)"match");
        rowData.add((Object)"row1col2Data");
        this.gridData.addRowData(rowData);
        Assert.assertEquals((Object)new Integer(1), (Object)this.gridData.getAvailableRowsCount());
        List grid = this.gridData.getRows();
        Assert.assertEquals((Object)"match", ((RowData)grid.get(0)).getColumnData().get(0));
    }

    @Test
    public void testAddRowDataWithFilterNoMatch() {
        RowData rowData = new RowData(this.gridData.getColumns());
        rowData.add((Object)"noMatch");
        rowData.add((Object)"row1col2Data");
        this.gridData.addRowData(rowData);
        Assert.assertEquals((Object)0, (Object)this.gridData.getAvailableRowsCount());
    }

    @Test
    public void testCreateColumns() {
        GridData mygrid = new GridData(new ColumnsBuilder(){

            public void configure() {
                this.addColumn("testcol1");
            }
        });
        Assert.assertEquals((long)1L, (long)mygrid.getColumns().getAsList().size());
        Assert.assertEquals((Object)0, (Object)mygrid.getColumnId("testcol1"));
    }

    @Test
    public void testGetColumnId() {
    }

    @Test
    public void testGetFilter() {
    }

    @Test
    public void testGetGridData() {
        Assert.assertTrue((this.gridData.getRows().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMaxSortValueFromBuilder() {
    }

    @Test
    public void testGetSize() {
        Assert.assertTrue((this.gridData.getSize() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGridData() {
        Assert.assertTrue((this.gridData.getAvailableRowsCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveRow() {
    }

    @Test
    public void testSort() {
    }
}

