/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.filters.AndFilter;
import de.twenty11.skysail.common.filters.Filter;
import de.twenty11.skysail.common.filters.LdapSearchFilter;
import de.twenty11.skysail.common.grids.ColumnDefinition;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ColumnsBuilder {
    private final List<ColumnDefinition> columnDefinitions = new LinkedList<ColumnDefinition>();
    private final Set<String> columnNames = new HashSet<String>();
    private Filter filter;
    private Map<String, String> filterKeyValues;
    private boolean configured = false;

    public abstract void configure();

    public ColumnsBuilder() {
        this.configure();
        this.applyFilter();
        this.configured = true;
    }

    public final ColumnDefinition addColumn(String name) {
        if (this.configured) {
            throw new IllegalStateException("addColumn is not to be called after getColumns has been called the first time.");
        }
        ColumnDefinition columnDefinition = new ColumnDefinition(name);
        this.columnDefinitions.add(columnDefinition);
        this.columnNames.add(name);
        return columnDefinition;
    }

    public final List<ColumnDefinition> getColumns() {
        return this.columnDefinitions;
    }

    private void applyFilter() {
        this.filter = this.filterKeyValues != null ? LdapSearchFilter.newInstance(this.filterKeyValues.get("filterExpression")) : AndFilter.newInstance(this.filterKeyValues, this.columnNames);
    }

    public final Filter getFilter() {
        return this.filter;
    }

    public final String toString() {
        return this.columnDefinitions.toString();
    }
}

