/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.forms;

import de.twenty11.skysail.common.forms.FieldDefinition;
import de.twenty11.skysail.common.forms.FieldType;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class FormBuilder {
    private Map<String, FieldDefinition> fieldDefinitions = new LinkedHashMap<String, FieldDefinition>();

    public abstract void configure();

    public final FieldDefinition addField(String fieldName, FieldType type) {
        FieldDefinition fieldDefinition = new FieldDefinition(fieldName, type, this);
        this.fieldDefinitions.put(fieldName, fieldDefinition);
        return fieldDefinition;
    }

    public final Map<String, FieldDefinition> getFields() {
        this.clear();
        this.configure();
        return this.fieldDefinitions;
    }

    private void clear() {
        this.fieldDefinitions.clear();
    }

    public final String toString() {
        if (this.fieldDefinitions == null || this.fieldDefinitions.size() == 0) {
            return "Empty column list. Did you run getColumns() yet?";
        }
        return this.fieldDefinitions.toString();
    }

    public Map<String, FieldDefinition> getColumns() {
        return this.getFields();
    }
}

