/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.filters;

import de.twenty11.skysail.common.filters.AbstractFilter;
import de.twenty11.skysail.common.filters.EqualFilter;
import de.twenty11.skysail.common.filters.Filter;
import de.twenty11.skysail.common.filters.FilterType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OrFilter
extends AbstractFilter {
    private static final long serialVersionUID = -4265118450543158146L;

    public static Filter newInstance(Map<String, String> valuesMap) {
        if (valuesMap == null || valuesMap.size() == 0) {
            return new OrFilter(FilterType.EMPTY);
        }
        ArrayList<Filter> operands = new ArrayList<Filter>();
        for (String key : valuesMap.keySet()) {
            String value = valuesMap.get(key);
            if (value == null) continue;
            EqualFilter filter = new EqualFilter(key, valuesMap.get(key));
            operands.add(filter);
        }
        return new OrFilter(FilterType.OR, null, operands);
    }

    public OrFilter(FilterType type) {
        this.setFilterType(type);
        this.setAttribute(null);
        this.setSubfilters((List)null);
        this.setValue(null);
    }

    public OrFilter(FilterType type, String attribute, List<Filter> subfilters) {
        this.setFilterType(type);
        this.setAttribute(attribute);
        this.setSubfilters((List)subfilters);
        this.setValue(null);
    }

    public OrFilter(FilterType type, String attribute, String value) {
        this.setFilterType(type);
        this.setAttribute(attribute);
        this.setSubfilters((List)null);
        this.setValue(value);
    }

    @Override
    public String getValue(String attribute) {
        return "";
    }

    @Override
    public boolean match(Map<String, String> properties) {
        for (Filter filter : this.getSubfilters()) {
            if (!filter.match(properties)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(|");
        for (Filter filter : this.getSubfilters()) {
            sb.append(filter.toString());
        }
        sb.append(')');
        return sb.toString();
    }
}

