/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.filters;

import de.twenty11.skysail.common.filters.AbstractFilter;
import de.twenty11.skysail.common.filters.Filter;
import de.twenty11.skysail.common.filters.FilterType;
import de.twenty11.skysail.common.internal.filters.FilterExpressionParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LdapSearchFilter
extends AbstractFilter {
    private static final long serialVersionUID = 6320587880866948360L;

    public static Filter newInstance(String filterString) {
        return new FilterExpressionParser(filterString).parse();
    }

    public LdapSearchFilter(FilterType type) {
        this.setFilterType(type);
        this.setAttribute(null);
        this.setSubfilters((List)null);
        this.setValue(null);
    }

    public LdapSearchFilter(FilterType present, String attribute) {
        this.setAttribute(attribute);
        this.setSubfilters((List)null);
    }

    public LdapSearchFilter(FilterType type, String attribute, Filter subfilter) {
        this.setFilterType(type);
        this.setAttribute(attribute);
        ArrayList<Filter> singleEntryList = new ArrayList<Filter>();
        singleEntryList.add(subfilter);
        this.setSubfilters(singleEntryList);
        this.setValue(null);
    }

    public LdapSearchFilter(FilterType type, String attribute, List<Filter> subfilters) {
        this.setFilterType(type);
        this.setAttribute(attribute);
        this.setSubfilters((List)subfilters);
        this.setValue(null);
    }

    public LdapSearchFilter(FilterType type, String attr, Object object) {
        this.setFilterType(type);
        this.setAttribute(attr);
        this.setSubfilters((List)null);
        this.setValue(object.toString());
    }

    public LdapSearchFilter(FilterType type, String attribute, String value) {
        this.setFilterType(type);
        this.setAttribute(attribute);
        this.setSubfilters((List)null);
        this.setValue(value);
    }

    @Override
    public String getValue(String attribute) {
        return super.getValue();
    }

    @Override
    public boolean match(Map<String, String> properties) {
        switch (this.getFilterType()) {
            case EMPTY: {
                return true;
            }
            case AND: {
                for (Filter filter : this.getSubfilters()) {
                    if (filter.match(properties)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Filter filter : this.getSubfilters()) {
                    if (!filter.match(properties)) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                Filter filter = (Filter)this.getSubfilters().get(0);
                return !filter.match(properties);
            }
            case PRESENT: {
                String prop = properties == null ? null : properties.get(this.getAttribute());
                return prop != null;
            }
        }
        return false;
    }

    private String print() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        switch (this.getFilterType()) {
            case AND: {
                sb.append('&');
                for (Filter filter : this.getSubfilters()) {
                    sb.append(filter.toString());
                }
                break;
            }
            case OR: {
                sb.append('|');
                for (Filter filter : this.getSubfilters()) {
                    sb.append(filter.toString());
                }
                break;
            }
            case NOT: {
                sb.append('!');
                sb.append(((Filter)this.getSubfilters().get(0)).toString());
                break;
            }
            case EQUALITY_MATCH: {
                sb.append(this.getAttribute());
                sb.append('=');
                sb.append(this.getValue());
                break;
            }
            case GREATER_OR_EQUAL: {
                sb.append(this.getAttribute());
                sb.append(">=");
                sb.append(this.getValue());
                break;
            }
            case LESS_OR_EQUAL: {
                sb.append(this.getAttribute());
                sb.append("<=");
                sb.append(this.getValue());
                break;
            }
            case PRESENT: {
                sb.append(this.getAttribute());
                sb.append("=*");
                break;
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        return this.print();
    }
}

