/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.filters;

import de.twenty11.skysail.common.filters.AbstractFilter;
import de.twenty11.skysail.common.filters.Filter;
import de.twenty11.skysail.common.filters.FilterType;
import de.twenty11.skysail.common.filters.SubstringFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndFilter
extends AbstractFilter {
    private static final long serialVersionUID = 1608849901671774650L;

    public static Filter newInstance(Map<String, String> valuesMap) {
        return AndFilter.newInstance(valuesMap, valuesMap.keySet());
    }

    public static Filter newInstance(Map<String, String> valuesMap, Set<String> validKeys) {
        if (valuesMap == null || valuesMap.size() == 0) {
            return new AndFilter(FilterType.EMPTY);
        }
        ArrayList<Filter> operands = new ArrayList<Filter>();
        for (String key : valuesMap.keySet()) {
            String value;
            if (!validKeys.contains(key) || (value = valuesMap.get(key)) == null) continue;
            SubstringFilter filter = new SubstringFilter(key, valuesMap.get(key));
            operands.add(filter);
        }
        return new AndFilter(FilterType.AND, null, operands);
    }

    public AndFilter(FilterType type) {
        this.setFilterType(type);
        this.setAttribute(null);
        this.setSubfilters((List)null);
        this.setValue(null);
    }

    public AndFilter(FilterType type, String attribute, List<Filter> subfilters) {
        this.setFilterType(type);
        this.setAttribute(attribute);
        this.setSubfilters((List)subfilters);
        this.setValue(null);
    }

    @Override
    public String getValue(String attribute) {
        if (this.getSubfilters() == null || this.getSubfilters().size() == 0) {
            return "";
        }
        for (Filter filter : this.getSubfilters()) {
            if (filter.getValue(attribute) == null) continue;
            return filter.getValue(attribute);
        }
        return "";
    }

    @Override
    public boolean match(Map<String, String> properties) {
        if (this.getSubfilters() == null) {
            return true;
        }
        for (Filter filter : this.getSubfilters()) {
            if (filter.match(properties)) continue;
            return false;
        }
        return true;
    }

    private String print() {
        if (this.getSubfilters() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(&");
        for (Filter filter : this.getSubfilters()) {
            sb.append(filter.toString());
        }
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        return this.print();
    }
}

