/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.SkysailData;
import de.twenty11.skysail.common.filters.AndFilter;
import de.twenty11.skysail.common.grids.ColumnsBuilder;
import de.twenty11.skysail.common.grids.GridData;
import de.twenty11.skysail.common.grids.RowData;
import de.twenty11.skysail.common.responses.SkysailResponse;
import de.twenty11.skysail.common.responses.SkysailSuccessResponse;
import java.util.HashMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonTest {
    private GridData gridData;
    private ObjectMapper mapper = new ObjectMapper();

    @Before
    public void setUp() throws Exception {
        HashMap parameters = new HashMap();
        this.gridData = new GridData(new ColumnsBuilder(){

            public void configure() {
                this.addColumn("col1");
                this.addColumn("col2");
            }
        });
        this.gridData.setFilter(AndFilter.newInstance(parameters));
    }

    @Test
    public void simpleSerialize() {
        SkysailSuccessResponse response = new SkysailSuccessResponse((SkysailData)this.gridData);
        try {
            String strRep = this.mapper.writeValueAsString((Object)response);
            Assert.assertTrue((boolean)strRep.contains("\"success\":true,\"debug\":false,\"message\":null"));
            Assert.assertTrue((boolean)strRep.contains("\"pageSize\":20,\"totalResults\":0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void simpleDeserialize() throws Exception {
        SkysailSuccessResponse payload = new SkysailSuccessResponse((SkysailData)this.gridData);
        String serializedPayload = this.mapper.writeValueAsString((Object)payload);
        SkysailResponse deserializedPayload = (SkysailResponse)this.mapper.readValue(serializedPayload, (TypeReference)new TypeReference<SkysailResponse<GridData>>(){});
        Assert.assertEquals((Object)"/", (Object)deserializedPayload.getContextPath());
        Assert.assertEquals((Object)true, (Object)deserializedPayload.getSuccess());
        Assert.assertEquals((Object)false, (Object)deserializedPayload.getDebug());
        Assert.assertEquals(null, (Object)deserializedPayload.getRequest());
        Assert.assertEquals(null, (Object)deserializedPayload.getMessage());
        Assert.assertEquals(null, (Object)deserializedPayload.getSortingRepresentation());
        Assert.assertEquals((Object)1, (Object)deserializedPayload.getPage());
        Assert.assertEquals((Object)0, (Object)deserializedPayload.getTotalResults());
        Assert.assertTrue((boolean)((GridData)payload.getData()).equals((Object)deserializedPayload.getData()));
    }

    @Test
    public void deserializeWithRows() throws Exception {
        RowData rowData = new RowData(this.gridData.getColumns());
        rowData.add((Object)"row1col1");
        rowData.add((Object)"row1col2");
        this.gridData.addRowData(rowData);
        SkysailSuccessResponse payload = new SkysailSuccessResponse((SkysailData)this.gridData);
        String serializedPayload = this.mapper.writeValueAsString((Object)payload);
        SkysailResponse deserializedPayload = (SkysailResponse)this.mapper.readValue(serializedPayload, (TypeReference)new TypeReference<SkysailResponse<GridData>>(){});
        Assert.assertTrue((boolean)((GridData)payload.getData()).equals((Object)deserializedPayload.getData()));
    }
}

