/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.testing.utils;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiTestingUtils {
    private static Logger logger = LoggerFactory.getLogger((String)OsgiTestingUtils.class.getName());

    public static Bundle getBundleForSymbolicName(BundleContext context, String symbolicName) {
        Bundle[] bundles;
        logger.info("testing existence of bundle with symbolic name '{}'", (Object)symbolicName);
        Bundle myBundle = null;
        for (Bundle bundle : bundles = context.getBundles()) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            myBundle = bundle;
        }
        return myBundle;
    }

    public static void dumpBundleInfo(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            System.out.println(bundle.getState() + ": " + bundle.getSymbolicName());
        }
    }

    public static void dumpServicesInfo(BundleContext context) {
        try {
            ServiceReference[] serviceReferences;
            for (ServiceReference sr : serviceReferences = context.getAllServiceReferences(null, null)) {
                System.out.println(sr.toString());
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }
}

