/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.test;

import de.twenty11.skysail.common.PresentableHeader;
import java.awt.Color;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PresentableHeaderTest {
    private PresentableHeader.Builder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = new PresentableHeader.Builder("text");
    }

    @Test
    public void testGetText() {
        PresentableHeader header = this.builder.build();
        Assert.assertThat((Object)header.getText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"text")));
    }

    @Test
    public void testGetLink() {
        this.builder.setLink("link");
        PresentableHeader header = this.builder.build();
        Assert.assertThat((Object)header.getLink(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"<a href='link'>text</a>")));
    }

    @Test
    public void testGetCategoryColor() {
        this.builder.setCategoryColor(new Color(1.0f, 1.0f, 1.0f));
        PresentableHeader header = this.builder.build();
        Assert.assertThat((Object)header.getCategoryColor().getRed(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)255)));
    }

    @Test
    public void testGetCategoryText() {
        this.builder.setCategoryText("cat");
        PresentableHeader header = this.builder.build();
        Assert.assertThat((Object)header.getCategoryText(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"cat")));
    }

    @Test
    public void testGetImage() {
        this.builder.setImage("img");
        PresentableHeader header = this.builder.build();
        Assert.assertThat((Object)header.getImage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"img")));
    }
}

